/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.android.tools.idea.ui.properties.BatchInvoker;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListenerManager {
    private final List<ListenerPairing> myListeners;
    private final Map<Consumer<?>, InvalidationListener> myConsumerMapping;
    private final List<CompositeListener> myCompositeListeners;
    private final BatchInvoker myInvoker;

    public ListenerManager() {
        this.myListeners = Lists.newArrayList();
        this.myConsumerMapping = Maps.newHashMap();
        this.myCompositeListeners = Lists.newArrayListWithExpectedSize((int)0);
        this.myInvoker = new BatchInvoker();
    }

    public ListenerManager(@NotNull BatchInvoker.Strategy invokeStrategy) {
        if (invokeStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invokeStrategy", "com/android/tools/idea/ui/properties/ListenerManager", "<init>"));
        }
        this.myListeners = Lists.newArrayList();
        this.myConsumerMapping = Maps.newHashMap();
        this.myCompositeListeners = Lists.newArrayListWithExpectedSize((int)0);
        this.myInvoker = new BatchInvoker(invokeStrategy);
    }

    public void listen(@NotNull ObservableValue<?> src, @NotNull InvalidationListener listener) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/ui/properties/ListenerManager", "listen"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/ListenerManager", "listen"));
        }
        this.myListeners.add(new ListenerPairing(src, listener));
    }

    public <T> void listen(final @NotNull ObservableValue<T> src, final @NotNull Consumer<T> listener) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/ui/properties/ListenerManager", "listen"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/ListenerManager", "listen"));
        }
        InvalidationListener listenerWrapper = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/ListenerManager$1", "onInvalidated"));
                }
                listener.consume(src.get());
            }
        };
        this.myConsumerMapping.put(listener, listenerWrapper);
        this.listen(src, listenerWrapper);
    }

    public void listenAndFire(@NotNull ObservableValue<?> src, @NotNull InvalidationListener listener) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/ui/properties/ListenerManager", "listenAndFire"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/ListenerManager", "listenAndFire"));
        }
        this.listen(src, listener);
        listener.onInvalidated(src);
    }

    public <T> void listenAndFire(@NotNull ObservableValue<T> src, @NotNull Consumer<T> listener) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/ui/properties/ListenerManager", "listenAndFire"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/ListenerManager", "listenAndFire"));
        }
        this.listen(src, listener);
        listener.consume(src.get());
    }

    @NotNull
    public CompositeListener listenAll(ObservableValue<?> ... values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/ui/properties/ListenerManager", "listenAll"));
        }
        CompositeListener listener = new CompositeListener(values);
        this.myCompositeListeners.add(listener);
        CompositeListener compositeListener = listener;
        if (compositeListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/ListenerManager", "listenAll"));
        }
        return compositeListener;
    }

    @NotNull
    public CompositeListener listenAll(@NotNull Collection<? extends ObservableValue<?>> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/ui/properties/ListenerManager", "listenAll"));
        }
        CompositeListener compositeListener = this.listenAll((ObservableValue[])Iterables.toArray(values, ObservableValue.class));
        if (compositeListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/ListenerManager", "listenAll"));
        }
        return compositeListener;
    }

    public void release(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/ListenerManager", "release"));
        }
        Iterator<ListenerPairing> i = this.myListeners.iterator();
        while (i.hasNext()) {
            ListenerPairing listenerPairing = i.next();
            if (listenerPairing.myListener != listener) continue;
            listenerPairing.dispose();
            i.remove();
        }
    }

    public void release(@NotNull Consumer<?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/ListenerManager", "release"));
        }
        InvalidationListener listenerWrapper = this.myConsumerMapping.get(listener);
        if (listenerWrapper == null) {
            return;
        }
        this.release(listenerWrapper);
    }

    public void release(@NotNull ObservableValue<?> observable) {
        if (observable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "com/android/tools/idea/ui/properties/ListenerManager", "release"));
        }
        Iterator<ListenerPairing> i = this.myListeners.iterator();
        while (i.hasNext()) {
            ListenerPairing listenerPairing = i.next();
            if (listenerPairing.myObservable != observable) continue;
            listenerPairing.dispose();
            i.remove();
        }
    }

    public void release(@NotNull Runnable listenAllRunnable) {
        if (listenAllRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenAllRunnable", "com/android/tools/idea/ui/properties/ListenerManager", "release"));
        }
        Iterator<CompositeListener> iterator = this.myCompositeListeners.iterator();
        while (iterator.hasNext()) {
            CompositeListener listener = iterator.next();
            if (!listener.ownsRunnable(listenAllRunnable)) continue;
            listener.dispose();
            iterator.remove();
        }
    }

    public void releaseAll() {
        for (ListenerPairing listenerPairing : this.myListeners) {
            listenerPairing.dispose();
        }
        this.myListeners.clear();
        for (CompositeListener compositeListener : this.myCompositeListeners) {
            compositeListener.dispose();
        }
        this.myCompositeListeners.clear();
    }

    public final class CompositeListener
    implements InvalidationListener,
    Runnable {
        @NotNull
        private final ObservableValue<?>[] myValues;
        @Nullable
        private Runnable myOnAnyInvalidated;

        public CompositeListener(ObservableValue<?> ... values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/ui/properties/ListenerManager$CompositeListener", "<init>"));
            }
            for (ObservableValue<?> value : this.myValues = values) {
                value.addListener(this);
            }
        }

        public void dispose() {
            for (ObservableValue<?> value : this.myValues) {
                value.removeListener(this);
            }
        }

        public void with(@NotNull Runnable onAnyInvalidated) {
            if (onAnyInvalidated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onAnyInvalidated", "com/android/tools/idea/ui/properties/ListenerManager$CompositeListener", "with"));
            }
            this.myOnAnyInvalidated = onAnyInvalidated;
        }

        boolean ownsRunnable(@NotNull Runnable onAnyInvalidated) {
            if (onAnyInvalidated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onAnyInvalidated", "com/android/tools/idea/ui/properties/ListenerManager$CompositeListener", "ownsRunnable"));
            }
            return onAnyInvalidated.equals(this.myOnAnyInvalidated);
        }

        @Override
        public void onInvalidated(@NotNull ObservableValue<?> sender) {
            if (sender == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/ListenerManager$CompositeListener", "onInvalidated"));
            }
            ListenerManager.this.myInvoker.enqueue(this);
        }

        @Override
        public void run() {
            if (this.myOnAnyInvalidated != null) {
                this.myOnAnyInvalidated.run();
            }
        }
    }

    private static class ListenerPairing {
        private final ObservableValue<?> myObservable;
        private final InvalidationListener myListener;

        public ListenerPairing(ObservableValue<?> src, InvalidationListener listener) {
            this.myObservable = src;
            this.myListener = listener;
            src.addListener(listener);
        }

        public void dispose() {
            this.myObservable.removeListener(this.myListener);
        }
    }
}

