/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.swing;

import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.google.common.base.Optional;
import com.intellij.ui.ColorPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;

public final class ColorProperty
extends OptionalProperty<Color>
implements ActionListener {
    @NotNull
    private final ColorPanel myColorPanel;

    public ColorProperty(@NotNull ColorPanel colorPanel) {
        if (colorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorPanel", "com/android/tools/idea/ui/properties/swing/ColorProperty", "<init>"));
        }
        this.myColorPanel = colorPanel;
        this.myColorPanel.addActionListener((ActionListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyInvalidated();
    }

    @Override
    protected void setDirectly(@NotNull Optional<Color> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/swing/ColorProperty", "setDirectly"));
        }
        this.myColorPanel.setSelectedColor((Color)value.orNull());
    }

    @Override
    @NotNull
    public Optional<Color> get() {
        Optional optional = Optional.fromNullable((Object)this.myColorPanel.getSelectedColor());
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/ColorProperty", "get"));
        }
        return optional;
    }
}

