/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Platform
extends InstallableComponent {
    private final AndroidVersion myVersion;
    private final boolean myIsDefaultPlatform;

    /*
     * WARNING - void declaration
     */
    public Platform(@NotNull ScopedStateStore store, @NotNull String name, long size, @NotNull String description, AndroidVersion version, boolean bl) {
        void isDefaultPlatform;
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/Platform", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/install/Platform", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/welcome/install/Platform", "<init>"));
        }
        super(store, name, size, description, FileOpUtils.create());
        this.myVersion = version;
        this.myIsDefaultPlatform = isDefaultPlatform;
    }

    @Nullable
    private static Platform getLatestPlatform(@NotNull ScopedStateStore store, @Nullable Map<String, RemotePackage> remotePackages) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/Platform", "getLatestPlatform"));
        }
        RemotePackage latest = InstallComponentsPath.findLatestPlatform(remotePackages);
        if (latest != null) {
            AndroidVersion version = DetailsTypes.getAndroidVersion((DetailsTypes.ApiDetailsType)((DetailsTypes.PlatformDetailsType)latest.getTypeDetails()));
            String versionName = SdkVersionInfo.getAndroidName((int)version.getFeatureLevel());
            String description = "Android platform libraries for targeting " + versionName + " platform";
            return new Platform(store, versionName, latest.getArchive().getComplete().getSize(), description, version, !version.isPreview());
        }
        return null;
    }

    @NotNull
    private static List<AndroidVersion> getInstalledPlatformVersions(@Nullable AndroidSdkHandler handler) {
        ArrayList result = Lists.newArrayList();
        if (handler != null) {
            RepositoryPackages packages = handler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(Platform.class)).getPackages();
            for (LocalPackage p : packages.getLocalPackages().values()) {
                if (!(p.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) continue;
                result.add(DetailsTypes.getAndroidVersion((DetailsTypes.ApiDetailsType)((DetailsTypes.PlatformDetailsType)p.getTypeDetails())));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Platform", "getInstalledPlatformVersions"));
        }
        return arrayList;
    }

    @Nullable
    public static ComponentTreeNode createSubtree(@NotNull ScopedStateStore store, @Nullable Map<String, RemotePackage> remotePackages) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/Platform", "createSubtree"));
        }
        Platform latestPlatform = Platform.getLatestPlatform(store, remotePackages);
        if (latestPlatform != null) {
            return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", latestPlatform);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<String> getRequiredSdkPackages(@Nullable Map<String, RemotePackage> remotePackages) {
        ArrayList requests = Lists.newArrayList((Object[])new String[]{DetailsTypes.getPlatformPath((AndroidVersion)this.myVersion), DetailsTypes.getSourcesPath((AndroidVersion)this.myVersion)});
        String buildTool = Platform.findLatestCompatibleBuildTool(remotePackages, this.myVersion);
        if (buildTool != null) {
            requests.add(buildTool);
        }
        ArrayList arrayList = requests;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Platform", "getRequiredSdkPackages"));
        }
        return arrayList;
    }

    private static String findLatestCompatibleBuildTool(@Nullable Map<String, RemotePackage> remotePackages, AndroidVersion version) {
        Revision revision = null;
        String path = null;
        if (remotePackages != null) {
            for (RemotePackage remote : remotePackages.values()) {
                Revision testRevision;
                if (!remote.getPath().startsWith("build-tools") || (testRevision = remote.getVersion()).getMajor() != version.getApiLevel() || revision != null && testRevision.compareTo(revision) <= 0) continue;
                revision = testRevision;
                path = remote.getPath();
            }
        }
        return path;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/Platform", "configure"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/Platform", "configure"));
        }
    }

    @Override
    public boolean isOptionalForSdkLocation(@Nullable AndroidSdkHandler handler) {
        List<AndroidVersion> locals = Platform.getInstalledPlatformVersions(handler);
        if (locals.isEmpty()) {
            return !this.myIsDefaultPlatform;
        }
        for (AndroidVersion androidVersion : locals) {
            int apiLevel;
            int n = apiLevel = androidVersion == null ? 0 : androidVersion.getApiLevel();
            if (this.myVersion.getFeatureLevel() != apiLevel) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedByDefault(@Nullable AndroidSdkHandler sdkHandler) {
        return false;
    }
}

