/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.table;

import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.layout.actions.TableLayoutSpanOperation;
import com.intellij.android.designer.designSurface.layout.grid.GridSelectionDecorator;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.layout.RadLinearLayout;
import com.intellij.android.designer.model.layout.actions.AllGravityAction;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.ICaption;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RadTableRowLayout
extends RadLinearLayout {
    private static final String[] LAYOUT_PARAMS = new String[]{"TableRow_Cell", "LinearLayout_Layout", "ViewGroup_MarginLayout"};
    private GridSelectionDecorator mySelectionDecorator;

    @Override
    @NotNull
    public String[] getLayoutParams() {
        if (LAYOUT_PARAMS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/table/RadTableRowLayout", "getLayoutParams"));
        }
        return LAYOUT_PARAMS;
    }

    public static boolean is(RadComponent component) {
        return component != null && component.getLayout() instanceof RadTableRowLayout;
    }

    private boolean isTableParent() {
        return this.myContainer.getParent() instanceof RadTableLayoutComponent;
    }

    @Override
    public boolean isHorizontal() {
        return true;
    }

    @Override
    public EditOperation processChildOperation(OperationContext context) {
        if (!this.isTableParent() || context.isTree()) {
            return super.processChildOperation(context);
        }
        if (context.is((Object)"layout_span")) {
            return new TableLayoutSpanOperation(context, this.mySelectionDecorator);
        }
        return null;
    }

    @Override
    public void addStaticDecorators(List<StaticDecorator> decorators, List<RadComponent> selection) {
        if (!this.isTableParent()) {
            super.addStaticDecorators(decorators, selection);
        }
    }

    @Override
    protected boolean supportsOrientation() {
        return false;
    }

    @Override
    public ComponentDecorator getChildSelectionDecorator(RadComponent component, List<RadComponent> selection) {
        if (this.isTableParent()) {
            if (this.mySelectionDecorator == null) {
                this.mySelectionDecorator = new GridSelectionDecorator(DrawingStyle.SELECTION){

                    @Override
                    public Rectangle getCellBounds(Component layer, RadComponent component) {
                        try {
                            RadTableLayoutComponent tableComponent = (RadTableLayoutComponent)component.getParent().getParent();
                            GridInfo gridInfo = tableComponent.getVirtualGridInfo();
                            int row = tableComponent.getChildren().indexOf(component.getParent());
                            Object[] rowComponents = gridInfo.components[row];
                            int column = ArrayUtil.indexOf((Object[])rowComponents, (Object)component);
                            int columnSpan = 1;
                            for (int i = column + 1; i < rowComponents.length && rowComponents[i] == component; ++i) {
                                ++columnSpan;
                            }
                            return 1.calculateBounds(layer, gridInfo, (RadComponent)tableComponent, component, row, column, 1, columnSpan);
                        }
                        catch (Throwable e) {
                            return new Rectangle();
                        }
                    }
                };
            }
            this.mySelectionDecorator.clear();
            if (selection.size() == 1) {
                TableLayoutSpanOperation.points(this.mySelectionDecorator);
            }
            return this.mySelectionDecorator;
        }
        return super.getChildSelectionDecorator(component, selection);
    }

    @Override
    public void addContainerSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, List<? extends RadViewComponent> selectedChildren) {
        super.addContainerSelectionActions(designer, actionGroup, selectedChildren);
        if (this.isTableParent()) {
            actionGroup.add((AnAction)new AllGravityAction(designer, selectedChildren));
        }
    }

    public ICaption getCaption(RadComponent component) {
        return this.isTableParent() ? this.myContainer.getParent().getLayout().getCaption(component) : null;
    }
}

