/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lang.databinding.DataBindingCompletionUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.animation.AndroidAnimationUtils;
import org.jetbrains.android.dom.animator.AndroidAnimatorUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.color.ColorDomFileDescription;
import org.jetbrains.android.dom.converters.FlagConverter;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.transition.TransitionDomFileDescription;
import org.jetbrains.android.dom.transition.TransitionDomUtil;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.XmlResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SimpleClassMapConstructor;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidCompletionContributor
extends CompletionContributor {
    private static final String LAYOUT_ATTRIBUTE_PREFIX = "layout_";

    private static void addAll(Collection<String> collection, CompletionResultSet set) {
        for (String s : collection) {
            set.addElement((LookupElement)LookupElementBuilder.create((String)s));
        }
    }

    private static boolean completeTagNames(@NotNull AndroidFacet facet, @NotNull XmlFile xmlFile, @NotNull CompletionResultSet resultSet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/AndroidCompletionContributor", "completeTagNames"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "org/jetbrains/android/AndroidCompletionContributor", "completeTagNames"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "org/jetbrains/android/AndroidCompletionContributor", "completeTagNames"));
        }
        if (ManifestDomFileDescription.isManifestFile(xmlFile, facet)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"manifest"));
            return false;
        }
        if (LayoutDomFileDescription.isLayoutFile(xmlFile)) {
            Map<String, PsiClass> classMap = facet.getClassMap("android.view.View", SimpleClassMapConstructor.getInstance());
            for (String rootTag : AndroidLayoutUtil.getPossibleRoots(facet)) {
                LookupElementBuilder builder;
                PsiClass aClass = classMap.get(rootTag);
                if (aClass != null) {
                    String name;
                    builder = LookupElementBuilder.create((Object)aClass, (String)rootTag);
                    String qualifiedName = aClass.getQualifiedName();
                    String string = name = qualifiedName == null ? null : AndroidUtils.getUnqualifiedName(qualifiedName);
                    if (name != null) {
                        builder = builder.withLookupString(name);
                    }
                } else {
                    builder = LookupElementBuilder.create((String)rootTag);
                }
                Icon icon = AndroidDomElementDescriptorProvider.getIconForViewTag(rootTag);
                if (icon != null) {
                    builder = builder.withIcon(icon);
                }
                resultSet.addElement((LookupElement)builder);
            }
            return false;
        }
        if (AndroidResourceDomFileDescription.doIsMyFile(xmlFile, ResourceFolderType.ANIM)) {
            AndroidCompletionContributor.addAll(AndroidAnimationUtils.getPossibleRoots(), resultSet);
            return false;
        }
        if (AndroidResourceDomFileDescription.doIsMyFile(xmlFile, ResourceFolderType.ANIMATOR)) {
            AndroidCompletionContributor.addAll(AndroidAnimatorUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (XmlResourceDomFileDescription.isXmlResourceFile(xmlFile)) {
            AndroidCompletionContributor.addAll(AndroidXmlResourcesUtil.getPossibleRoots(facet), resultSet);
            return false;
        }
        if (AndroidDrawableDomUtil.isDrawableResourceFile(xmlFile)) {
            AndroidCompletionContributor.addAll(AndroidDrawableDomUtil.getPossibleRoots(facet), resultSet);
            return false;
        }
        if (TransitionDomFileDescription.isTransitionFile(xmlFile)) {
            AndroidCompletionContributor.addAll(TransitionDomUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (ColorDomFileDescription.isColorResourceFile(xmlFile)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"selector"));
            return false;
        }
        return true;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        PsiElement originalParent;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/android/AndroidCompletionContributor", "fillCompletionVariants"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "org/jetbrains/android/AndroidCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters.getPosition();
        PsiElement originalPosition = parameters.getOriginalPosition();
        AndroidFacet facet = AndroidFacet.getInstance(position);
        if (facet == null) {
            return;
        }
        PsiElement parent = position.getParent();
        PsiElement psiElement = originalParent = originalPosition != null ? originalPosition.getParent() : null;
        if (parent instanceof XmlTag) {
            int refOffset;
            PsiElement element;
            XmlTag tag = (XmlTag)parent;
            if (tag.getParentTag() != null) {
                return;
            }
            ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
            if (startTagName == null || startTagName.getPsi() != position) {
                return;
            }
            PsiFile file = tag.getContainingFile();
            if (!(file instanceof XmlFile)) {
                return;
            }
            PsiReference reference = file.findReferenceAt(parameters.getOffset());
            if (reference != null && (element = reference.getElement()) != null && (refOffset = element.getTextRange().getStartOffset() + reference.getRangeInElement().getStartOffset()) != position.getTextRange().getStartOffset()) {
                return;
            }
            if (!AndroidCompletionContributor.completeTagNames(facet, (XmlFile)file, resultSet)) {
                resultSet.stopHere();
            }
        } else if (parent instanceof XmlAttribute) {
            ASTNode attrName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(parent.getNode());
            if (attrName == null || attrName.getPsi() != position) {
                return;
            }
            AndroidCompletionContributor.addAndroidPrefixElement(position, parent, resultSet);
            AndroidCompletionContributor.customizeAddedAttributes(facet, parameters, (XmlAttribute)parent, resultSet);
        } else if (originalParent instanceof XmlAttributeValue) {
            AndroidCompletionContributor.completeTailsInFlagAttribute(parameters, resultSet, (XmlAttributeValue)originalParent);
            AndroidCompletionContributor.completeDataBindingTypeAttr(parameters, resultSet, (XmlAttributeValue)originalParent);
        }
    }

    private static void addAndroidPrefixElement(PsiElement position, PsiElement parent, CompletionResultSet resultSet) {
        if (position.getText().startsWith("android:")) {
            return;
        }
        PsiElement grandparent = parent.getParent();
        if (!(grandparent instanceof XmlTag)) {
            return;
        }
        DomElement element = DomManager.getDomManager((Project)grandparent.getProject()).getDomElement((XmlTag)grandparent);
        if (!(element instanceof LayoutElement) && !(element instanceof PreferenceElement)) {
            return;
        }
        String prefix = ((XmlTag)grandparent).getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        if (prefix == null || prefix.length() < 3) {
            return;
        }
        LookupElementBuilder e = LookupElementBuilder.create((String)(prefix + ":")).withTypeText("[Namespace Prefix]", true);
        resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)e, (double)Double.MAX_VALUE));
    }

    private static void customizeAddedAttributes(final AndroidFacet facet, CompletionParameters parameters, final XmlAttribute attribute, final CompletionResultSet resultSet) {
        boolean localNameCompletion;
        XmlTag gp = attribute.getParent();
        if (gp == null) {
            return;
        }
        final XmlTag tag = gp;
        DomElement element = DomManager.getDomManager((Project)gp.getProject()).getDomElement(tag);
        if (!(element instanceof LayoutElement)) {
            return;
        }
        if (attribute.getName().contains(":")) {
            String nsPrefix = attribute.getNamespacePrefix();
            if (nsPrefix.length() == 0) {
                return;
            }
            if (!"http://schemas.android.com/apk/res/android".equals(tag.getNamespaceByPrefix(nsPrefix))) {
                return;
            }
            localNameCompletion = true;
        } else {
            localNameCompletion = false;
        }
        final HashMap prefix2ns = new HashMap();
        resultSet.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

            public void consume(CompletionResult result) {
                LookupElement lookupElement = result.getLookupElement();
                Object obj = lookupElement.getObject();
                if (obj instanceof String) {
                    String s = (String)obj;
                    int index = s.indexOf(58);
                    String attributeName = s.substring(index + 1);
                    if (index > 0) {
                        String prefix = s.substring(0, index);
                        String ns = (String)prefix2ns.get(prefix);
                        if (ns == null) {
                            ns = tag.getNamespaceByPrefix(prefix);
                            prefix2ns.put(prefix, ns);
                        }
                        if ("http://schemas.android.com/apk/res/android".equals(ns)) {
                            boolean deprecated = AndroidCompletionContributor.isFrameworkAttributeDeprecated(facet, attribute, attributeName);
                            result = AndroidCompletionContributor.customizeLayoutAttributeLookupElement(lookupElement, result, attributeName, deprecated);
                        }
                    } else if (localNameCompletion) {
                        result = AndroidCompletionContributor.customizeLayoutAttributeLookupElement(lookupElement, result, attributeName, false);
                    }
                }
                resultSet.passResult(result);
            }
        });
    }

    private static boolean isFrameworkAttributeDeprecated(AndroidFacet facet, XmlAttribute attribute, String attributeName) {
        ResourceManager manager = facet.getResourceManager("android", (PsiElement)attribute.getParent());
        if (manager == null) {
            return false;
        }
        AttributeDefinitions attributes = manager.getAttributeDefinitions();
        if (attributes == null) {
            return false;
        }
        AttributeDefinition attributeDefinition = attributes.getAttrDefByName(attributeName);
        return attributeDefinition != null && attributeDefinition.isAttributeDeprecated();
    }

    private static CompletionResult customizeLayoutAttributeLookupElement(LookupElement lookupElement, CompletionResult result, String localName, final boolean markDeprecated) {
        if (!localName.startsWith(LAYOUT_ATTRIBUTE_PREFIX)) {
            if (markDeprecated) {
                return result.withLookupElement(PrioritizedLookupElement.withPriority((LookupElement)new LookupElementDecorator<LookupElement>(lookupElement){

                    public void renderElement(LookupElementPresentation presentation) {
                        super.renderElement(presentation);
                        presentation.setStrikeout(true);
                    }
                }, (double)-1.0));
            }
            return result;
        }
        String localSuffix = localName.substring(LAYOUT_ATTRIBUTE_PREFIX.length());
        if (localSuffix.length() > 0) {
            final HashSet lookupStrings = new HashSet((Collection)lookupElement.getAllLookupStrings());
            lookupStrings.add((Object)localSuffix);
            lookupElement = new LookupElementDecorator<LookupElement>(lookupElement){

                public Set<String> getAllLookupStrings() {
                    return lookupStrings;
                }

                public void renderElement(LookupElementPresentation presentation) {
                    super.renderElement(presentation);
                    presentation.setStrikeout(markDeprecated);
                }
            };
        }
        return result.withLookupElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0));
    }

    private static void completeDataBindingTypeAttr(CompletionParameters parameters, CompletionResultSet resultSet, XmlAttributeValue originalParent) {
        PsiElement gp = originalParent.getParent();
        if (!(gp instanceof XmlAttribute)) {
            return;
        }
        GenericAttributeValue domElement = DomManager.getDomManager((Project)gp.getProject()).getDomElement((XmlAttribute)gp);
        if (domElement == null) {
            return;
        }
        if (DomUtil.getParentOfType((DomElement)domElement, Data.class, (boolean)true) != null && ((XmlAttribute)gp).getName().equals("type")) {
            DataBindingCompletionUtil.addCompletions(parameters, resultSet);
        }
    }

    private static void completeTailsInFlagAttribute(CompletionParameters parameters, CompletionResultSet resultSet, XmlAttributeValue parent) {
        String prefix;
        Set<String> valueSet;
        Converter converter;
        String currentValue = parent.getValue();
        if (currentValue == null || currentValue.length() == 0 || currentValue.endsWith("|")) {
            return;
        }
        PsiElement grandparent = parent.getParent();
        if (!(grandparent instanceof XmlAttribute)) {
            return;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)grandparent.getProject()).getDomElement((XmlAttribute)grandparent);
        Converter converter2 = converter = domValue != null ? domValue.getConverter() : null;
        if (!(converter instanceof FlagConverter)) {
            return;
        }
        TextRange valueRange = parent.getValueTextRange();
        if (valueRange != null && valueRange.getEndOffset() == parameters.getOffset() && (valueSet = ((FlagConverter)converter).getValues()).size() > 0 && valueSet.contains(prefix = resultSet.getPrefixMatcher().getPrefix())) {
            ArrayList<String> filteredValues = new ArrayList<String>(valueSet);
            DelimitedListConverter.filterVariants(filteredValues, (GenericDomValue)domValue);
            for (String variant : filteredValues) {
                resultSet.addElement((LookupElement)LookupElementBuilder.create((String)(prefix + "|" + variant)));
            }
        }
    }
}

