/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidFinalPackageElementType
extends PackagingElementType<AndroidFinalPackageElement> {
    @NonNls
    public static final String TYPE_ID = "android-final-package";

    protected AndroidFinalPackageElementType() {
        super(TYPE_ID, "Android Final Package");
    }

    public static AndroidFinalPackageElementType getInstance() {
        return (AndroidFinalPackageElementType)AndroidFinalPackageElementType.getInstance(AndroidFinalPackageElementType.class);
    }

    public Icon getCreateElementIcon() {
        return AndroidIcons.Android;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "canCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "canCreate"));
        }
        return AndroidFinalPackageElementType.getAndroidApplicationFacets(context, context.getModulesProvider().getModules()).size() > 0 && !AndroidArtifactUtil.containsAndroidPackage(context, artifact);
    }

    @NotNull
    private static List<AndroidFacet> getAndroidApplicationFacets(@NotNull ArtifactEditorContext context, @NotNull Module[] modules) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "getAndroidApplicationFacets"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "getAndroidApplicationFacets"));
        }
        ArrayList<AndroidFacet> result = new ArrayList<AndroidFacet>();
        for (Module module : modules) {
            for (AndroidFacet facet : context.getFacetsProvider().getFacetsByType(module, AndroidFacet.ID)) {
                if (facet.isLibraryProject()) continue;
                result.add(facet);
            }
        }
        ArrayList<AndroidFacet> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "getAndroidApplicationFacets"));
        }
        return arrayList;
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "chooseAndCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "chooseAndCreate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "chooseAndCreate"));
        }
        List<AndroidFacet> facets = AndroidFinalPackageElementType.getAndroidApplicationFacets(context, context.getModulesProvider().getModules());
        AndroidFacet facet = AndroidArtifactUtil.chooseAndroidApplicationModule(context.getProject(), facets);
        if (facet == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "chooseAndCreate"));
            }
            return list;
        }
        List<AndroidFinalPackageElement> list = Collections.singletonList(new AndroidFinalPackageElement(context.getProject(), facet));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "chooseAndCreate"));
        }
        return list;
    }

    @NotNull
    public AndroidFinalPackageElement createEmpty(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "createEmpty"));
        }
        AndroidFinalPackageElement androidFinalPackageElement = new AndroidFinalPackageElement(project, null);
        if (androidFinalPackageElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType", "createEmpty"));
        }
        return androidFinalPackageElement;
    }
}

