/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiRootFileDescription<T extends DomElement>
extends AndroidResourceDomFileDescription<T> {
    private final ImmutableSet<String> myTagNames;

    public AbstractMultiRootFileDescription(@NotNull Class<T> aClass, @NotNull ResourceFolderType resourceFolderType, @NotNull ImmutableSet<String> tagNames) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/android/dom/AbstractMultiRootFileDescription", "<init>"));
        }
        if (resourceFolderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceFolderType", "org/jetbrains/android/dom/AbstractMultiRootFileDescription", "<init>"));
        }
        if (tagNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagNames", "org/jetbrains/android/dom/AbstractMultiRootFileDescription", "<init>"));
        }
        super(aClass, (String)tagNames.iterator().next(), resourceFolderType);
        this.myTagNames = tagNames;
    }

    public AbstractMultiRootFileDescription(@NotNull Class<T> aClass, @NotNull ResourceFolderType resourceFolderType, String ... tagNames) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/android/dom/AbstractMultiRootFileDescription", "<init>"));
        }
        if (resourceFolderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceFolderType", "org/jetbrains/android/dom/AbstractMultiRootFileDescription", "<init>"));
        }
        if (tagNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagNames", "org/jetbrains/android/dom/AbstractMultiRootFileDescription", "<init>"));
        }
        super(aClass, tagNames[0], resourceFolderType);
        this.myTagNames = ImmutableSet.copyOf((Object[])tagNames);
    }

    public boolean acceptsOtherRootTagNames() {
        return true;
    }

    @Override
    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/dom/AbstractMultiRootFileDescription", "isMyFile"));
        }
        if (!super.isMyFile(file, module)) {
            return false;
        }
        XmlTag rootTag = file.getRootTag();
        return rootTag != null && this.myTagNames.contains((Object)rootTag.getName());
    }
}

