/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.resources.ResourceType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.android.dom.converters.TargetApiConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsAttributeUtil {
    private static final ResolvingConverter LAYOUT_REFERENCE_CONVERTER = new ResourceReferenceConverter(Collections.singleton(ResourceType.LAYOUT.getName()));
    private static final ResolvingConverter ACTIVITY_CLASS_CONVERTER = new PackageClassConverter(true, "android.app.Activity");
    private static final List<AttributeFormat> NO_FORMATS = Collections.emptyList();
    public static final String ATTR_NODE = "node";
    public static final String ATTR_STRICT = "strict";
    public static final String ATTR_REMOVE = "remove";
    public static final String ATTR_REPLACE = "replace";
    public static final String ATTR_OVERRIDE_LIBRARY = "overrideLibrary";
    private static final ImmutableMap<String, List<AttributeFormat>> ATTRIBUTES = ImmutableMap.builder().put((Object)"actionBarNavMode", Collections.singletonList(AttributeFormat.Flag)).put((Object)"context", (Object)ImmutableList.of((Object)((Object)AttributeFormat.Reference), (Object)((Object)AttributeFormat.String))).put((Object)"ignore", NO_FORMATS).put((Object)"listfooter", Collections.singletonList(AttributeFormat.Reference)).put((Object)"listheader", Collections.singletonList(AttributeFormat.Reference)).put((Object)"listitem", Collections.singletonList(AttributeFormat.Reference)).put((Object)"layout", Collections.singletonList(AttributeFormat.Reference)).put((Object)"locale", NO_FORMATS).put((Object)"menu", NO_FORMATS).put((Object)"showIn", Collections.singletonList(AttributeFormat.Reference)).put((Object)"targetApi", NO_FORMATS).put((Object)"node", Collections.singletonList(AttributeFormat.Enum)).put((Object)"strict", NO_FORMATS).put((Object)"remove", NO_FORMATS).put((Object)"replace", NO_FORMATS).put((Object)"overrideLibrary", NO_FORMATS).build();
    private static final ImmutableMap<String, ResolvingConverter> CONVERTERS = ImmutableMap.builder().put((Object)"actionBarNavMode", (Object)new StaticEnumConverter("standard", "list", "tabs")).put((Object)"context", (Object)ACTIVITY_CLASS_CONVERTER).put((Object)"listfooter", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"listheader", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"listitem", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"layout", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"showIn", (Object)LAYOUT_REFERENCE_CONVERTER).put((Object)"node", (Object)new StaticEnumConverter("merge", "replace", "strict", "merge-only-attributes", "remove", "removeAll")).put((Object)"targetApi", (Object)new TargetApiConverter()).build();

    @Nullable
    public static ResolvingConverter getConverter(@NotNull AttributeDefinition attrDef) {
        if (attrDef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrDef", "org/jetbrains/android/dom/attrs/ToolsAttributeUtil", "getConverter"));
        }
        String name = attrDef.getName();
        ResolvingConverter converter = (ResolvingConverter)CONVERTERS.get((Object)name);
        return converter != null ? converter : AndroidDomUtil.getConverter(attrDef);
    }

    @NotNull
    public static Set<String> getAttributeNames() {
        ImmutableSet immutableSet = ATTRIBUTES.keySet();
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/ToolsAttributeUtil", "getAttributeNames"));
        }
        return immutableSet;
    }

    @Nullable
    public static AttributeDefinition getAttrDefByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/ToolsAttributeUtil", "getAttrDefByName"));
        }
        if (!ATTRIBUTES.containsKey((Object)name)) {
            return null;
        }
        Collection formats = (Collection)ATTRIBUTES.get((Object)name);
        AttributeDefinition def = new AttributeDefinition(name);
        def.addFormats(formats);
        return def;
    }
}

