/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.maven;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Map;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.maven.MavenArtifactResolvedInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;

@com.intellij.openapi.components.State(name="AndroidExternalApklibDependenciesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AndroidExternalApklibDependenciesManager
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static AndroidExternalApklibDependenciesManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager", "getInstance"));
        }
        return (AndroidExternalApklibDependenciesManager)ServiceManager.getService((Project)project, AndroidExternalApklibDependenciesManager.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    @Nullable
    public MavenArtifactResolvedInfo getResolvedInfoForArtifact(@NotNull MavenId mavenId) {
        if (mavenId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenId", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager", "getResolvedInfoForArtifact"));
        }
        String key = AndroidMavenUtil.getMavenIdStringForFileName(mavenId);
        return this.myState.getResolvedInfoMap().get(key);
    }

    @Nullable
    public String getArtifactFilePath(@NotNull String mavenIdStr) {
        if (mavenIdStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenIdStr", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager", "getArtifactFilePath"));
        }
        return this.myState.getArtifactFilesMap().get(mavenIdStr);
    }

    public void setResolvedInfoForArtifact(@NotNull MavenId mavenId, @NotNull MavenArtifactResolvedInfo info) {
        if (mavenId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenId", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager", "setResolvedInfoForArtifact"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager", "setResolvedInfoForArtifact"));
        }
        String key = AndroidMavenUtil.getMavenIdStringForFileName(mavenId);
        this.myState.getResolvedInfoMap().put(key, info);
    }

    public void setArtifactFilePath(@NotNull MavenId mavenId, @NotNull String path) {
        if (mavenId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenId", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager", "setArtifactFilePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager", "setArtifactFilePath"));
        }
        String key = AndroidMavenUtil.getMavenIdStringForFileName(mavenId);
        this.myState.getArtifactFilesMap().put(key, path);
    }

    public static class MavenDependencyInfo {
        private String myGroupId;
        private String myArtifactId;
        private String myVersion;
        private String myType;
        private String myScope;
        private String myPath;
        private String myLibName;

        public MavenDependencyInfo() {
        }

        @NotNull
        public static MavenDependencyInfo create(@NotNull MavenArtifact artifact) {
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager$MavenDependencyInfo", "create"));
            }
            String path = artifact.getPathForExtraArtifact(null, null);
            String libName = artifact.getLibraryName();
            MavenDependencyInfo mavenDependencyInfo = new MavenDependencyInfo(artifact.getMavenId(), artifact.getType(), artifact.getScope(), path, libName);
            if (mavenDependencyInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager$MavenDependencyInfo", "create"));
            }
            return mavenDependencyInfo;
        }

        private MavenDependencyInfo(@NotNull MavenId mavenId, @NotNull String type, @NotNull String scope, @NotNull String path, @NotNull String libName) {
            if (mavenId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenId", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager$MavenDependencyInfo", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager$MavenDependencyInfo", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager$MavenDependencyInfo", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager$MavenDependencyInfo", "<init>"));
            }
            if (libName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libName", "org/jetbrains/android/maven/AndroidExternalApklibDependenciesManager$MavenDependencyInfo", "<init>"));
            }
            this.myGroupId = mavenId.getGroupId();
            this.myArtifactId = mavenId.getArtifactId();
            this.myVersion = mavenId.getVersion();
            this.myType = type;
            this.myScope = scope;
            this.myPath = path;
            this.myLibName = libName;
        }

        public String getGroupId() {
            return this.myGroupId;
        }

        public String getArtifactId() {
            return this.myArtifactId;
        }

        public String getVersion() {
            return this.myVersion;
        }

        public String getType() {
            return this.myType;
        }

        public String getScope() {
            return this.myScope;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getLibName() {
            return this.myLibName;
        }

        public void setGroupId(String groupId) {
            this.myGroupId = groupId;
        }

        public void setArtifactId(String artifactId) {
            this.myArtifactId = artifactId;
        }

        public void setVersion(String version) {
            this.myVersion = version;
        }

        public void setType(String type) {
            this.myType = type;
        }

        public void setScope(String scope) {
            this.myScope = scope;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        public void setLibName(String libName) {
            this.myLibName = libName;
        }
    }

    public static class State {
        private Map<String, String> myArtifactFilesMap = new HashMap();
        private Map<String, MavenArtifactResolvedInfo> myResolvedInfoMap = new HashMap();

        @Tag(value="resolved-infos")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, MavenArtifactResolvedInfo> getResolvedInfoMap() {
            return this.myResolvedInfoMap;
        }

        @Tag(value="artifacts")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, String> getArtifactFilesMap() {
            return this.myArtifactFilesMap;
        }

        public void setArtifactFilesMap(Map<String, String> artifactFilesMap) {
            this.myArtifactFilesMap = artifactFilesMap;
        }

        public void setResolvedInfoMap(Map<String, MavenArtifactResolvedInfo> artifactId2SdkData) {
            this.myResolvedInfoMap = artifactId2SdkData;
        }
    }
}

