/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkData {
    private final Map<IAndroidTarget, SoftReference<AndroidTargetData>> myTargetDataByTarget;
    private final DeviceManager myDeviceManager;
    private final int myPlatformToolsRevision;
    private static final ConcurrentMap<String, SoftReference<AndroidSdkData>> ourCache = Maps.newConcurrentMap();
    private AndroidSdkHandler mySdkHandler;

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation) {
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        return AndroidSdkData.getSdkData(sdkLocation, false);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation, boolean forceReparse) {
        File canonicalLocation;
        SoftReference cachedRef;
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)sdkLocation.getPath());
        if (!forceReparse && (cachedRef = (SoftReference)ourCache.get(canonicalPath)) != null) {
            AndroidSdkData cachedData = (AndroidSdkData)cachedRef.get();
            if (cachedData == null) {
                ourCache.remove(canonicalPath, cachedRef);
            } else {
                return cachedData;
            }
        }
        if (!IdeSdks.isValidAndroidSdkPath(canonicalLocation = new File(canonicalPath))) {
            return null;
        }
        AndroidSdkData sdkData = new AndroidSdkData(canonicalLocation);
        ourCache.put(canonicalPath, (SoftReference<AndroidSdkData>)new SoftReference((Object)sdkData));
        return sdkData;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        File file = new File(FileUtil.toSystemDependentName((String)sdkPath));
        return AndroidSdkData.getSdkData(file);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath != null) {
            return AndroidSdkData.getSdkData(sdk.getHomePath());
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (sdk != null) {
            return AndroidSdkData.getSdkData(sdk);
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkData"));
        }
        return AndroidSdkData.getSdkData(module.getProject());
    }

    private AndroidSdkData(@NotNull File localSdk) {
        if (localSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localSdk", "org/jetbrains/android/sdk/AndroidSdkData", "<init>"));
        }
        this.myTargetDataByTarget = Maps.newHashMap();
        this.mySdkHandler = AndroidSdkHandler.getInstance((File)localSdk);
        File location = this.getLocation();
        String locationPath = location.getPath();
        this.myPlatformToolsRevision = AndroidCommonUtils.parsePackageRevision((String)locationPath, (String)"platform-tools");
        this.myDeviceManager = DeviceManager.createInstance((File)location, (ILogger)new MessageBuildingSdkLog());
    }

    @NotNull
    public File getLocation() {
        File location = this.mySdkHandler.getLocation();
        assert (location != null);
        File file = location;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getLocation"));
        }
        return file;
    }

    @Deprecated
    @NotNull
    public String getPath() {
        String string = this.getLocation().getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getPath"));
        }
        return string;
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        return this.mySdkHandler.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        IAndroidTarget[] iAndroidTargetArray = targets.toArray(new IAndroidTarget[targets.size()]);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getTargets"));
        }
        return iAndroidTargetArray;
    }

    @NotNull
    private Collection<IAndroidTarget> getTargetCollection() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        Collection collection = this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargets((ProgressIndicator)progress);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getTargetCollection"));
        }
        return collection;
    }

    @NotNull
    public IAndroidTarget[] getTargets(boolean includeAddOns) {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        ArrayList result = Lists.newArrayList();
        if (!includeAddOns) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform()) continue;
                result.add(target);
            }
        } else {
            result.addAll(targets);
        }
        IAndroidTarget[] iAndroidTargetArray = result.toArray(new IAndroidTarget[result.size()]);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getTargets"));
        }
        return iAndroidTargetArray;
    }

    @Nullable
    public IAndroidTarget findTargetByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/sdk/AndroidSdkData", "findTargetByName"));
        }
        for (IAndroidTarget target : this.getTargets()) {
            if (!target.getName().equals(name)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public IAndroidTarget findTargetByApiLevel(@NotNull String apiLevel) {
        if (apiLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apiLevel", "org/jetbrains/android/sdk/AndroidSdkData", "findTargetByApiLevel"));
        }
        for (IAndroidTarget target : this.getTargets()) {
            if (!AndroidSdkUtils.targetHasId(target, apiLevel)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public IAndroidTarget findTargetByHashString(@NotNull String hashString) {
        if (hashString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashString", "org/jetbrains/android/sdk/AndroidSdkData", "findTargetByHashString"));
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargetFromHashString(hashString, (ProgressIndicator)progress);
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AndroidSdkData sdkData = (AndroidSdkData)obj;
        return FileUtil.filesEqual((File)this.getLocation(), (File)sdkData.getLocation());
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.getLocation());
    }

    @NotNull
    public DeviceManager getDeviceManager() {
        DeviceManager deviceManager = this.myDeviceManager;
        if (deviceManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getDeviceManager"));
        }
        return deviceManager;
    }

    @NotNull
    public AndroidTargetData getTargetData(@NotNull IAndroidTarget target) {
        AndroidTargetData targetData;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/sdk/AndroidSdkData", "getTargetData"));
        }
        SoftReference<AndroidTargetData> targetDataRef = this.myTargetDataByTarget.get(target);
        AndroidTargetData androidTargetData = targetData = targetDataRef != null ? (AndroidTargetData)targetDataRef.get() : null;
        if (targetData == null) {
            targetData = new AndroidTargetData(this, target);
            this.myTargetDataByTarget.put(target, (SoftReference<AndroidTargetData>)new SoftReference((Object)targetData));
        }
        AndroidTargetData androidTargetData2 = targetData;
        if (androidTargetData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getTargetData"));
        }
        return androidTargetData2;
    }

    @NotNull
    public AndroidSdkHandler getSdkHandler() {
        AndroidSdkHandler androidSdkHandler = this.mySdkHandler;
        if (androidSdkHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/sdk/AndroidSdkData", "getSdkHandler"));
        }
        return androidSdkHandler;
    }
}

