/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.annotations.NotNull;

public class HintBasedErrorReporter
implements ErrorReporter {
    private final Editor myEditor;

    public HintBasedErrorReporter(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/android/util/HintBasedErrorReporter", "<init>"));
        }
        this.myEditor = editor;
    }

    @Override
    public void report(@NotNull String message, @NotNull String title) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/util/HintBasedErrorReporter", "report"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/android/util/HintBasedErrorReporter", "report"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IncorrectOperationException(message);
        }
        HintManager.getInstance().showErrorHint(this.myEditor, message);
    }
}

