/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.java.stubs.JavaClassElementType;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.Nullable;

public class PsiClassStubImpl<T extends PsiClass>
extends StubBase<T>
implements PsiClassStub<T> {
    private final StringRef myQualifiedName;
    private final StringRef myName;
    private final StringRef myBaseRefText;
    private final byte myFlags;
    private LanguageLevel myLanguageLevel = null;
    private StringRef mySourceFileName = null;

    public PsiClassStubImpl(JavaClassElementType type2, StubElement parent2, String qualifiedName, String name, @Nullable String baseRefText, byte flags) {
        this(type2, parent2, StringRef.fromString(qualifiedName), StringRef.fromString(name), StringRef.fromString(baseRefText), flags);
    }

    public PsiClassStubImpl(JavaClassElementType type2, StubElement parent2, StringRef qualifiedName, StringRef name, StringRef baseRefText, byte flags) {
        super(parent2, type2);
        this.myQualifiedName = qualifiedName;
        this.myName = name;
        this.myBaseRefText = baseRefText;
        this.myFlags = flags;
        if (StubBasedPsiElementBase.ourTraceStubAstBinding) {
            String creationTrace = "Stub creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            this.putUserData(StubBasedPsiElementBase.CREATION_TRACE, creationTrace);
        }
    }

    @Override
    public String getName() {
        return StringRef.toString(this.myName);
    }

    @Override
    public String getQualifiedName() {
        return StringRef.toString(this.myQualifiedName);
    }

    @Override
    public String getBaseClassReferenceText() {
        return StringRef.toString(this.myBaseRefText);
    }

    @Override
    public boolean isDeprecated() {
        return (this.myFlags & 1) != 0;
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return (this.myFlags & 0x80) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.myFlags & 2) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.myFlags & 4) != 0;
    }

    @Override
    public boolean isEnumConstantInitializer() {
        return PsiClassStubImpl.isEnumConstInitializer(this.myFlags);
    }

    public static boolean isEnumConstInitializer(byte flags) {
        return (flags & 8) != 0;
    }

    @Override
    public boolean isAnonymous() {
        return PsiClassStubImpl.isAnonymous(this.myFlags);
    }

    public static boolean isAnonymous(byte flags) {
        return (flags & 0x10) != 0;
    }

    @Override
    public boolean isAnnotationType() {
        return (this.myFlags & 0x20) != 0;
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel != null ? this.myLanguageLevel : LanguageLevel.HIGHEST;
    }

    @Override
    public String getSourceFileName() {
        return StringRef.toString(this.mySourceFileName);
    }

    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    public void setSourceFileName(StringRef sourceFileName) {
        this.mySourceFileName = sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.mySourceFileName = StringRef.fromString(sourceFileName);
    }

    @Override
    public boolean isAnonymousInQualifiedNew() {
        return (this.myFlags & 0x40) != 0;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public static byte packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation) {
        byte flags = 0;
        if (isDeprecated) {
            flags = (byte)(flags | 1);
        }
        if (isInterface) {
            flags = (byte)(flags | 2);
        }
        if (isEnum) {
            flags = (byte)(flags | 4);
        }
        if (isEnumConstantInitializer) {
            flags = (byte)(flags | 8);
        }
        if (isAnonymous) {
            flags = (byte)(flags | 0x10);
        }
        if (isAnnotationType) {
            flags = (byte)(flags | 0x20);
        }
        if (isInQualifiedNew) {
            flags = (byte)(flags | 0x40);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 0x80);
        }
        return flags;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiClassStub[");
        if (this.isInterface()) {
            builder.append("interface ");
        }
        if (this.isAnonymous()) {
            builder.append("anonymous ");
        }
        if (this.isEnum()) {
            builder.append("enum ");
        }
        if (this.isAnnotationType()) {
            builder.append("annotation ");
        }
        if (this.isEnumConstantInitializer()) {
            builder.append("enumInit ");
        }
        if (this.isDeprecated()) {
            builder.append("deprecated ");
        }
        if (this.hasDeprecatedAnnotation()) {
            builder.append("deprecatedA ");
        }
        builder.append("name=").append(this.getName()).append(" fqn=").append(this.getQualifiedName());
        if (this.getBaseClassReferenceText() != null) {
            builder.append(" baseref=").append(this.getBaseClassReferenceText());
        }
        if (this.isAnonymousInQualifiedNew()) {
            builder.append(" inqualifnew");
        }
        builder.append("]");
        return builder.toString();
    }
}

