/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import javax.swing.UIManager;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    private static float SCALE_FACTOR = JBUI.calculateScaleFactor();

    private static float calculateScaleFactor() {
        if (SystemInfo.isMac) {
            LOG.info("UI scale factor: 1.0");
            return 1.0f;
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            LOG.info("UI scale factor: 1.0");
            return 1.0f;
        }
        float s = 1.0f;
        if (SystemInfo.isLinux) {
            int dpi = JBUI.getSystemDPI();
            s = dpi < 120 ? 1.0f : (dpi < 144 ? 1.25f : (dpi < 168 ? 1.5f : (dpi < 192 ? 1.75f : 2.0f)));
            LOG.info("UI scale factor: " + s);
            return s;
        }
        int size = -1;
        if (SystemInfo.isWindows) {
            UIUtil.initSystemFontData();
            Pair<String, Integer> fdata = UIUtil.getSystemFontData();
            if (fdata != null) {
                size = fdata.getSecond();
            }
        }
        if (size == -1) {
            size = Fonts.label().getSize();
        }
        s = size <= 13 ? 1.0f : (size <= 16 ? 1.25f : (size <= 18 ? 1.5f : (size < 24 ? 1.75f : 2.0f)));
        LOG.info("UI scale factor: " + s);
        return s;
    }

    private static int getSystemDPI() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            return 96;
        }
    }

    public static float scale(float f) {
        return f * SCALE_FACTOR;
    }

    public static boolean isHiDPI() {
        return SCALE_FACTOR > 1.0f;
    }

    public static class Fonts {
        public static JBFont label() {
            return JBFont.create(UIManager.getFont("Label.font"), false);
        }
    }
}

