/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J%\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isInCycle", "", "T", "Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "from", "(Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;Ljava/lang/Object;)Z", "Graph", "GraphBuilder", "kotlin-compiler"})
public final class FiniteBoundRestrictionChecker {
    public static final FiniteBoundRestrictionChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void check(@NotNull KtClass declaration, @NotNull ClassDescriptor classDescriptor, @NotNull DiagnosticSink diagnosticHolder) {
        Object object;
        DeclarationDescriptor it;
        Collection collection;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean bl;
        Object it2;
        TypeParameterDescriptor element$iv22;
        List problemNodes;
        Iterable $receiver$iv$iv2;
        block9: {
            void destination$iv$iv2;
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
            Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
            TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
            if (typeConstructor2.getParameters().isEmpty()) {
                return;
            }
            TypeConstructor typeConstructor3 = typeConstructor2;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
            Graph<TypeParameterDescriptor> graph2 = new GraphBuilder(typeConstructor3).build();
            Iterable iterable = graph2.getNodes();
            Iterable iterable2 = iterable;
            Collection collection2 = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                TypeParameterDescriptor it3 = (TypeParameterDescriptor)element$iv$iv;
                if (!INSTANCE.isInCycle(graph2, it3)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            problemNodes = (List)destination$iv$iv2;
            if (problemNodes.isEmpty()) {
                return;
            }
            for (TypeParameterDescriptor typeParameterDescriptor : typeConstructor2.getParameters()) {
                if (!problemNodes.contains(typeParameterDescriptor)) continue;
                DeclarationDescriptor declarationDescriptor = typeParameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "typeParameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (psiElement == null) {
                    psiElement = declaration;
                }
                PsiElement element = psiElement;
                diagnosticHolder.report(Errors.FINITE_BOUNDS_VIOLATION.on(element));
                return;
            }
            Iterable iterable3 = problemNodes;
            for (TypeParameterDescriptor element$iv22 : iterable3) {
                it2 = element$iv22;
                if (!(Intrinsics.areEqual(it2.getSource(), SourceElement.NO_SOURCE) ^ true)) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        $receiver$iv$iv2 = problemNodes;
        element$iv22 = $receiver$iv;
        it2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor $i$a$1$filter = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getContainingDeclaration();
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (DeclarationDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            object = DescriptorUtilsKt.getFqNameUnsafe(it).asString();
            collection.add(object);
        }
        SortedSet sortedSet = CollectionsKt.toSortedSet((List)destination$iv$iv);
        diagnosticHolder.report(Errors.FINITE_BOUNDS_VIOLATION_IN_JAVA.on(declaration, CollectionsKt.joinToString$default(sortedSet, ", ", null, null, 0, null, null, 62, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> boolean isInCycle(@NotNull Graph<T> $receiver, T from) {
        void result2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        DFS.VisitedWithSet visited2 = new DFS.VisitedWithSet<T>(from, (Ref.BooleanRef)result2){
            final /* synthetic */ Object $from;
            final /* synthetic */ Ref.BooleanRef $result;

            public boolean checkAndMarkVisited(T current) {
                boolean added = super.checkAndMarkVisited(current);
                if (!added && Intrinsics.areEqual(current, this.$from)) {
                    this.$result.element = true;
                }
                return added;
            }
            {
                this.$from = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }
        };
        DFS.AbstractNodeHandler handler2 = new DFS.AbstractNodeHandler<T, Unit>(){

            public void result() {
            }
        };
        DFS.Neighbors neighbors2 = new DFS.Neighbors<T>($receiver){
            final /* synthetic */ Graph receiver$0;

            @NotNull
            public List<T> getNeighbors(T current) {
                return this.receiver$0.getNeighbors(current);
            }
            {
                this.receiver$0 = $receiver;
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf(from), neighbors2, visited2, handler2);
        return result2.element;
    }

    private FiniteBoundRestrictionChecker() {
        INSTANCE = this;
    }

    static {
        new FiniteBoundRestrictionChecker();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$GraphBuilder;", "", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)V", "edgeLists", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "", "nodes", "", "processedTypeConstructors", "Ljava/util/HashSet;", "getTypeConstructor", "()Lorg/jetbrains/kotlin/types/TypeConstructor;", "addEdge", "", "from", "to", "build", "Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "buildGraph", "", "kotlin-compiler"})
    private static final class GraphBuilder {
        private final Set<TypeParameterDescriptor> nodes;
        private final HashMap<TypeParameterDescriptor, List<TypeParameterDescriptor>> edgeLists;
        private final HashSet<TypeConstructor> processedTypeConstructors;
        @NotNull
        private final TypeConstructor typeConstructor;

        @NotNull
        public final Graph<TypeParameterDescriptor> build() {
            this.buildGraph(this.typeConstructor);
            return new Graph<TypeParameterDescriptor>(this){
                @NotNull
                private final Set<TypeParameterDescriptor> nodes;
                final /* synthetic */ GraphBuilder this$0;

                @NotNull
                public Set<TypeParameterDescriptor> getNodes() {
                    return this.nodes;
                }

                @NotNull
                public List<TypeParameterDescriptor> getNeighbors(@NotNull TypeParameterDescriptor node) {
                    Intrinsics.checkParameterIsNotNull(node, "node");
                    List<T> list2 = (List<T>)GraphBuilder.access$getEdgeLists$p(this.this$0).get(node);
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    return list2;
                }
                {
                    this.this$0 = $outer;
                    this.nodes = GraphBuilder.access$getNodes$p($outer);
                }
            };
        }

        private final boolean addEdge(TypeParameterDescriptor from, TypeParameterDescriptor to) {
            Object object;
            Map $receiver$iv = this.edgeLists;
            Object value$iv = $receiver$iv.get(from);
            if (value$iv == null) {
                ArrayList<TypeParameterDescriptor> answer$iv = CollectionsKt.arrayListOf(new TypeParameterDescriptor[0]);
                $receiver$iv.put(from, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return ((List)object).add(to);
        }

        /*
         * WARNING - void declaration
         */
        private final void buildGraph(TypeConstructor typeConstructor2) {
            Iterable $receiver$iv = typeConstructor2.getParameters();
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)element$iv;
                Collection collection = typeParameter.getUpperBounds();
                Intrinsics.checkExpressionValueIsNotNull(collection, "typeParameter.upperBounds");
                Collection<KotlinType> boundClosure2 = TypeUtilsKt.boundClosure(collection);
                Collection<KotlinType> constituentTypes = TypeUtilsKt.constituentTypes(boundClosure2);
                for (KotlinType constituentType : constituentTypes) {
                    void $receiver$iv2;
                    TypeConstructor constituentTypeConstructor = constituentType.getConstructor();
                    if (this.processedTypeConstructors.contains(constituentTypeConstructor) ^ true) {
                        this.processedTypeConstructors.add(constituentTypeConstructor);
                        TypeConstructor typeConstructor3 = constituentTypeConstructor;
                        Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "constituentTypeConstructor");
                        this.buildGraph(typeConstructor3);
                    }
                    if (constituentTypeConstructor.getParameters().size() != constituentType.getArguments().size()) continue;
                    Iterable iterable = constituentType.getArguments();
                    int index$iv = 0;
                    for (Object item$iv : $receiver$iv2) {
                        void typeProjection;
                        int n = index$iv++;
                        TypeProjection typeProjection2 = (TypeProjection)item$iv;
                        int i = n;
                        if (!(Intrinsics.areEqual((Object)typeProjection.getProjectionKind(), (Object)Variance.INVARIANT) ^ true)) continue;
                        TypeParameterDescriptor typeParameterDescriptor = typeParameter;
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                        this.nodes.add(typeParameterDescriptor);
                        TypeParameterDescriptor typeParameterDescriptor2 = constituentTypeConstructor.getParameters().get(i);
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "constituentTypeConstructor.parameters[i]");
                        this.nodes.add(typeParameterDescriptor2);
                        TypeParameterDescriptor typeParameterDescriptor3 = typeParameter;
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor3, "typeParameter");
                        TypeParameterDescriptor typeParameterDescriptor4 = constituentTypeConstructor.getParameters().get(i);
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor4, "constituentTypeConstructor.parameters[i]");
                        this.addEdge(typeParameterDescriptor3, typeParameterDescriptor4);
                    }
                }
            }
        }

        @NotNull
        public final TypeConstructor getTypeConstructor() {
            return this.typeConstructor;
        }

        public GraphBuilder(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
            this.typeConstructor = typeConstructor2;
            this.nodes = SetsKt.hashSetOf(new TypeParameterDescriptor[0]);
            this.edgeLists = MapsKt.hashMapOf(new Pair[0]);
            this.processedTypeConstructors = SetsKt.hashSetOf(new TypeConstructor[0]);
        }

        @NotNull
        public static final /* synthetic */ HashMap access$getEdgeLists$p(GraphBuilder $this) {
            return $this.edgeLists;
        }

        @NotNull
        public static final /* synthetic */ Set access$getNodes$p(GraphBuilder $this) {
            return $this.nodes;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "T", "", "nodes", "", "getNodes", "()Ljava/util/Set;", "getNeighbors", "", "node", "(Ljava/lang/Object;)Ljava/util/List;", "kotlin-compiler"})
    private static interface Graph<T> {
        @NotNull
        public Set<T> getNodes();

        @NotNull
        public List<T> getNeighbors(T var1);
    }
}

