/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IConnectionStreams;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminWriter;
import org.netbeans.lib.cvsclient.command.update.UpdatedFileInfo;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.ILocalFileWriter;
import org.netbeans.lib.cvsclient.file.IReaderFactory;
import org.netbeans.lib.cvsclient.response.AbstractResponseHandler;
import org.netbeans.lib.cvsclient.response.IResponseServices;

public final class DefaultResponseHandler
extends AbstractResponseHandler {
    @Override
    public void processErrorMessageResponse(byte[] message, IResponseServices responseServices) {
        responseServices.getEventSender().notifyMessageListeners(message, true, false);
    }

    @Override
    public void processMessageResponse(byte[] message, IResponseServices responseServices) {
        responseServices.getEventSender().notifyMessageListeners(message, false, false);
    }

    @Override
    public void processMessageTaggedResponse(byte[] message, IResponseServices responseServices) {
        responseServices.getEventSender().notifyMessageListeners(message, false, true);
    }

    @Override
    public void processBinaryMessageResponse(int fileLength, byte[] binaryContent, IResponseServices responseServices) {
        responseServices.getEventSender().notifyFileInfoListeners(binaryContent);
    }

    @Override
    public void processCheckedInResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        FileObject fileObject = clientEnvironment.getCvsFileSystem().getFileObject(relativeLocalDirectory, repositoryFilePath);
        Entry entry = Entry.createEntryForLine(entryLine);
        if (entry.isAddedFile() || entry.isRemoved()) {
            entry.setDummyTimestamp();
        } else {
            File file = clientEnvironment.getCvsFileSystem().getLocalFileSystem().getFile(fileObject);
            String mode = responseServices.getNextFileMode();
            boolean readOnly = mode != null && FileUtils.isReadOnlyMode(mode);
            clientEnvironment.getFileReadOnlyHandler().setFileReadOnly(file, readOnly);
            Date date = new Date(file.lastModified());
            entry.parseConflictString(Entry.getLastModifiedDateFormatter().format(date));
        }
        clientEnvironment.getAdminWriter().setEntry(fileObject.getParent(), entry, clientEnvironment.getCvsFileSystem());
        responseServices.getEventSender().notifyEntryListeners(fileObject, entry);
    }

    @Override
    public void processNewEntryResponse(String relativeLocalDirectory, String repositoryFilePath, IResponseServices responseServoces, String entryLine, IClientEnvironment clientEnvironment) throws IOException {
        FileObject fileObject = clientEnvironment.getCvsFileSystem().getFileObject(relativeLocalDirectory, repositoryFilePath);
        Entry entry = Entry.createEntryForLine(entryLine);
        entry.setDummyTimestamp();
        clientEnvironment.getAdminWriter().setEntry(fileObject.getParent(), entry, clientEnvironment.getCvsFileSystem());
        responseServoces.getEventSender().notifyEntryListeners(fileObject, entry);
    }

    @Override
    public void processSetStaticDirectoryResponse(String relativeLocalDirectory, String repositoryFilePath, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        ICvsFileSystem cvsFileSystem = clientEnvironment.getCvsFileSystem();
        DirectoryObject directoryObject = cvsFileSystem.getDirectoryObject(relativeLocalDirectory, repositoryFilePath);
        IAdminWriter adminWriter = clientEnvironment.getAdminWriter();
        adminWriter.ensureCvsDirectory(directoryObject, repositoryFilePath, clientEnvironment.getCvsRoot(), cvsFileSystem);
        adminWriter.setEntriesDotStatic(directoryObject, true, cvsFileSystem);
        responseServices.getEventSender().notifyDirectoryListeners(directoryObject, true);
    }

    @Override
    public void processClearStaticDirectoryResponse(String relativeLocalDirectory, String repositoryDirectoryPath, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        ICvsFileSystem cvsFileSystem = clientEnvironment.getCvsFileSystem();
        DirectoryObject directoryObject = cvsFileSystem.getDirectoryObject(relativeLocalDirectory, repositoryDirectoryPath);
        IAdminWriter adminWriter = clientEnvironment.getAdminWriter();
        adminWriter.ensureCvsDirectory(directoryObject, repositoryDirectoryPath, clientEnvironment.getCvsRoot(), cvsFileSystem);
        adminWriter.setEntriesDotStatic(directoryObject, false, cvsFileSystem);
        responseServices.getEventSender().notifyDirectoryListeners(directoryObject, false);
    }

    @Override
    public void processSetStickyResponse(String relativeLocalDirectory, String repositoryFilePath, String tag, IClientEnvironment clientEnvironment) throws IOException {
        DirectoryObject directoryObject = clientEnvironment.getCvsFileSystem().getDirectoryObject(relativeLocalDirectory, repositoryFilePath);
        clientEnvironment.getAdminWriter().setStickyTagForDirectory(directoryObject, tag, clientEnvironment.getCvsFileSystem());
    }

    @Override
    public void processClearStickyResponse(String relativeLocalDirectory, String repositoryFilePath, IClientEnvironment clientEnvironment) throws IOException {
        ICvsFileSystem cvsFileSystem = clientEnvironment.getCvsFileSystem();
        DirectoryObject directoryObject = cvsFileSystem.getDirectoryObject(relativeLocalDirectory, repositoryFilePath);
        IAdminWriter adminWriter = clientEnvironment.getAdminWriter();
        adminWriter.ensureCvsDirectory(directoryObject, repositoryFilePath, clientEnvironment.getCvsRoot(), cvsFileSystem);
        adminWriter.setStickyTagForDirectory(directoryObject, null, cvsFileSystem);
    }

    @Override
    public void processNotifiedResponse(String relativeLocalDirectory, String repositoryFilePath, IClientEnvironment clientEnvironment) {
    }

    @Override
    public void processRemovedResponse(String relativeLocalDirectory, String repositoryFilePath, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        ICvsFileSystem fileSystem = clientEnvironment.getCvsFileSystem();
        FileObject fileObject = fileSystem.getFileObject(relativeLocalDirectory, repositoryFilePath);
        clientEnvironment.getLocalFileWriter().removeLocalFile(fileObject, fileSystem, clientEnvironment.getFileReadOnlyHandler());
        clientEnvironment.getAdminWriter().removeEntryForFile(fileObject, fileSystem);
        responseServices.getEventSender().notifyFileInfoListeners(new UpdatedFileInfo(fileObject, fileSystem.getLocalFileSystem().getFile(fileObject), UpdatedFileInfo.UpdatedType.REMOVED, null));
    }

    @Override
    public void processRemoveEntryResponse(String relativeLocalDirectory, String repositoryFilePath, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        ICvsFileSystem fileSystem = clientEnvironment.getCvsFileSystem();
        FileObject fileObject = fileSystem.getFileObject(relativeLocalDirectory, repositoryFilePath);
        clientEnvironment.getAdminWriter().removeEntryForFile(fileObject, fileSystem);
        responseServices.getEventSender().notifyEntryListeners(fileObject, null);
    }

    @Override
    public void processCopyFileResponse(String relativeLocalDirectory, String repositoryFilePath, String newName, IClientEnvironment clientEnvironment) throws IOException {
        FileObject fileObject = clientEnvironment.getCvsFileSystem().getFileObject(relativeLocalDirectory, repositoryFilePath);
        clientEnvironment.getLocalFileWriter().renameLocalFile(fileObject, clientEnvironment.getCvsFileSystem(), newName);
    }

    @Override
    public void processModTimeResponse(Date modifiedDate, IResponseServices responseServices) {
        responseServices.setNextFileDate(modifiedDate);
    }

    @Override
    public void processModeResponse(String mode, IResponseServices responseServices) {
        responseServices.setNextFileMode(mode);
    }

    @Override
    public void processTemplateResponse(String relativeLocalDirectory, String repositoryFilePath, int length, IClientEnvironment clientEnvironment, IConnectionStreams connectionStreams) throws IOException {
        DirectoryObject directoryObject = clientEnvironment.getCvsFileSystem().getDirectoryObject(relativeLocalDirectory, repositoryFilePath);
        clientEnvironment.getAdminWriter().writeTemplateFile(directoryObject, length, connectionStreams.getInputStream(), connectionStreams.getReaderFactory(), clientEnvironment);
    }

    @Override
    public void processModuleExpansionResponse(String localPath, IResponseServices responseServices) {
        responseServices.getEventSender().notifyModuleExpansionListeners(localPath);
    }

    @Override
    public void processUpdatedResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, String mode, int fileLength, IClientEnvironment clientEnvironment, IResponseServices responseServices, IConnectionStreams connectionStreams) throws IOException {
        DefaultResponseHandler.processUpdatedMergedResponse(clientEnvironment, relativeLocalDirectory, repositoryFilePath, entryLine, responseServices, mode, fileLength, connectionStreams, false);
    }

    @Override
    public void processMergedResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, String mode, int fileLength, IClientEnvironment clientEnvironment, IResponseServices responseServices, IConnectionStreams connectionStreams) throws IOException {
        DefaultResponseHandler.processUpdatedMergedResponse(clientEnvironment, relativeLocalDirectory, repositoryFilePath, entryLine, responseServices, mode, fileLength, connectionStreams, true);
    }

    @Override
    public void processValidRequestsResponse(String validRequests, IResponseServices responseServices) {
    }

    private static void processUpdatedMergedResponse(IClientEnvironment clientEnvironment, String relativeLocalDirectory, String repositoryFilePath, String entryLine, IResponseServices responseServices, String mode, int fileLength, IConnectionStreams connectionStreams, boolean merged) throws IOException {
        ICvsFileSystem cvsFileSystem = clientEnvironment.getCvsFileSystem();
        FileObject fileObject = cvsFileSystem.getFileObject(relativeLocalDirectory, repositoryFilePath);
        Entry entry = Entry.createEntryForLine(entryLine);
        ILocalFileWriter localFileWriter = clientEnvironment.getLocalFileWriter();
        localFileWriter.setNextFileDate(responseServices.getNextFileDate());
        localFileWriter.setNextFileMode(mode);
        boolean binary = entry.isBinary();
        boolean readOnly = FileUtils.isReadOnlyMode(mode);
        Charset charSet = entry.isUnicode() ? Charset.forName("UTF-16LE") : null;
        DefaultResponseHandler.writeFile(fileObject, fileLength, connectionStreams.getInputStream(), connectionStreams.getReaderFactory(), binary, readOnly, clientEnvironment, charSet);
        DefaultResponseHandler.updateEntriesFileTime(fileObject, entry, cvsFileSystem, merged);
        IAdminWriter adminWriter = clientEnvironment.getAdminWriter();
        adminWriter.ensureCvsDirectory(fileObject.getParent(), repositoryFilePath, clientEnvironment.getCvsRoot(), cvsFileSystem);
        adminWriter.setEntry(fileObject.getParent(), entry, cvsFileSystem);
        responseServices.getEventSender().notifyEntryListeners(fileObject, entry);
        responseServices.getEventSender().notifyFileInfoListeners(new UpdatedFileInfo(fileObject, cvsFileSystem.getLocalFileSystem().getFile(fileObject), merged ? UpdatedFileInfo.UpdatedType.MERGED : UpdatedFileInfo.UpdatedType.UPDATED, entry));
    }

    private static void writeFile(FileObject fileObject, int length, InputStream inputStream, IReaderFactory readerFactory, boolean binary, boolean readOnly, IClientEnvironment clientEnvironment, Charset charSet) throws IOException {
        if (binary) {
            clientEnvironment.getLocalFileWriter().writeBinaryFile(fileObject, length, inputStream, readOnly, clientEnvironment.getFileReadOnlyHandler(), clientEnvironment.getCvsFileSystem());
        } else {
            clientEnvironment.getLocalFileWriter().writeTextFile(fileObject, length, inputStream, readOnly, readerFactory, clientEnvironment.getFileReadOnlyHandler(), clientEnvironment.getCvsFileSystem().getLocalFileSystem(), charSet);
        }
    }

    private static void updateEntriesFileTime(FileObject fileObject, Entry entry, ICvsFileSystem fileSystem, boolean merged) {
        if (entry.isAddedFile()) {
            entry.setDummyTimestamp();
        } else {
            File file = fileSystem.getLocalFileSystem().getFile(fileObject);
            if (entry.isConflict()) {
                if (entry.isTimeStampMatchesFile()) {
                    Date date = new Date(file.lastModified());
                    entry.parseConflictString(DefaultResponseHandler.getEntryConflict(date, true, merged));
                } else {
                    entry.parseConflictString(entry.getConflictStringWithoutConflict());
                }
            } else {
                Date date = new Date(file.lastModified());
                entry.parseConflictString(DefaultResponseHandler.getEntryConflict(date, false, merged));
            }
        }
    }

    @NonNls
    private static String getEntryConflict(Date date, boolean conflict, boolean merged) {
        if (merged) {
            if (conflict) {
                return "Result of merge+" + Entry.formatLastModifiedDate(date);
            }
            return "Result of merge";
        }
        return Entry.formatLastModifiedDate(date);
    }
}

