/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.sun.tools.javac.util.BaseFileObject;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Paths;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

class OptimizedFileManager
extends DefaultFileManager {
    private boolean myUseZipFileIndex;
    private final Map<File, DefaultFileManager.Archive> myArchives;
    private final Map<File, Boolean> myIsFile = new HashMap<File, Boolean>();
    private final Map<File, File[]> myDirectoryCache = new HashMap<File, File[]>();
    public static final File[] NULL_FILE_ARRAY = new File[0];
    private static final boolean ourUseContentCache = Boolean.valueOf(System.getProperty("javac.use.content.cache", "false"));
    private final Map<InputFileObject, SoftReference<CharBuffer>> myContentCache = ourUseContentCache ? new HashMap() : Collections.emptyMap();
    private final ByteBufferCache myByteBufferCache = new ByteBufferCache();
    private static volatile boolean ourPathCacheClearProblem = false;

    public OptimizedFileManager() throws Throwable {
        super(new Context(), true, null);
        Field archivesField = DefaultFileManager.class.getDeclaredField("archives");
        archivesField.setAccessible(true);
        this.myArchives = (Map)archivesField.get((Object)this);
        try {
            Field useZipFileIndexField = DefaultFileManager.class.getDeclaredField("useZipFileIndex");
            useZipFileIndexField.setAccessible(true);
            this.myUseZipFileIndex = (Boolean)useZipFileIndexField.get((Object)this);
        }
        catch (Exception e) {
            this.myUseZipFileIndex = false;
        }
    }

    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        String name = packageName == null || packageName.isEmpty() ? relativeName.replace('\\', '/') : packageName.replace('.', '/') + "/" + relativeName.replace('\\', '/');
        return this.getFileForInput(location, name);
    }

    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        String name = className.replace('.', '/') + kind.extension;
        return this.getFileForInput(location, name);
    }

    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<InputFileObject> result = files instanceof Collection ? new ArrayList(((Collection)files).size()) : new ArrayList<InputFileObject>();
        for (File file : files) {
            result.add(new InputFileObject(file));
        }
        return result;
    }

    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable locationRoots = this.getLocation(location);
        if (locationRoots == null) {
            return Collections.emptyList();
        }
        String relativePath = packageName.replace('.', File.separatorChar);
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (File root : locationRoots) {
            File directory;
            DefaultFileManager.Archive archive = this.myArchives.get(root);
            boolean isFile = archive != null ? true : this.isFile(root);
            if (isFile) {
                this.collectFromArchive(root, archive, relativePath, kinds, recurse, results);
                continue;
            }
            File file = directory = relativePath.length() != 0 ? new File(root, relativePath) : root;
            if (recurse) {
                this.collectFromDirectoryRecursively(directory, kinds, results, true);
                continue;
            }
            this.collectFromDirectory(directory, kinds, results);
        }
        return results.toList();
    }

    public void fileGenerated(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            this.myDirectoryCache.remove(parent);
        }
    }

    private boolean isFile(File root) {
        Boolean cachedIsFile = this.myIsFile.get(root);
        if (cachedIsFile == null) {
            cachedIsFile = root.isFile();
            this.myIsFile.put(root, cachedIsFile);
        }
        return cachedIsFile;
    }

    private void collectFromArchive(File root, DefaultFileManager.Archive archive, String relativePath, Set<JavaFileObject.Kind> kinds, boolean recurse, ListBuffer<JavaFileObject> result) {
        String separator;
        if (archive == null) {
            try {
                archive = this.openArchive(root);
            }
            catch (IOException ex) {
                this.log.error("error.reading.file", root, ex.getLocalizedMessage());
                return;
            }
        }
        String string = separator = this.myUseZipFileIndex ? File.separator : "/";
        if (relativePath.length() != 0) {
            if (!this.myUseZipFileIndex) {
                relativePath = relativePath.replace('\\', '/');
            }
            if (!relativePath.endsWith(separator)) {
                relativePath = relativePath + separator;
            }
        }
        this.collectArchiveFiles(archive, relativePath, kinds, result);
        if (recurse) {
            for (String s : archive.getSubdirectories()) {
                if (!s.startsWith(relativePath) || s.equals(relativePath)) continue;
                if (!s.endsWith(separator)) {
                    s = s + separator;
                }
                this.collectArchiveFiles(archive, s, kinds, result);
            }
        }
    }

    private void collectFromDirectory(File directory, Set<JavaFileObject.Kind> fileKinds, ListBuffer<JavaFileObject> result) {
        File[] children = this.listChildren(directory);
        if (children != null) {
            boolean acceptUnknownFiles = fileKinds.contains((Object)JavaFileObject.Kind.OTHER);
            for (File child : children) {
                if (!this.isValidFile(child.getName(), fileKinds) || acceptUnknownFiles && !this.isFile(child)) continue;
                InputFileObject fe = new InputFileObject(child);
                result.append((JavaFileObject)((Object)fe));
            }
        }
    }

    private void collectFromDirectoryRecursively(File file, Set<JavaFileObject.Kind> fileKinds, ListBuffer<JavaFileObject> result, boolean isRootCall) {
        File[] children = this.listChildren(file);
        String name = file.getName();
        if (children != null) {
            if (isRootCall || SourceVersion.isIdentifier(name)) {
                for (File child : children) {
                    this.collectFromDirectoryRecursively(child, fileKinds, result, false);
                }
            }
        } else if (this.isValidFile(name, fileKinds)) {
            InputFileObject fe = new InputFileObject(file);
            result.append((JavaFileObject)((Object)fe));
        }
    }

    private File[] listChildren(File file) {
        File[] cached = this.myDirectoryCache.get(file);
        if (cached == null) {
            cached = file.listFiles();
            this.myDirectoryCache.put(file, cached != null ? cached : NULL_FILE_ARRAY);
        }
        return cached == NULL_FILE_ARRAY ? null : cached;
    }

    private void collectArchiveFiles(DefaultFileManager.Archive archive, String relativePath, Set<JavaFileObject.Kind> fileKinds, ListBuffer<JavaFileObject> result) {
        List files = archive.getFiles(relativePath);
        if (files != null) {
            while (!files.isEmpty()) {
                String file = (String)files.head;
                if (this.isValidFile(file, fileKinds)) {
                    result.append(archive.getFileObject(relativePath, file));
                }
                files = files.tail;
            }
        }
    }

    private boolean isValidFile(String name, Set<JavaFileObject.Kind> fileKinds) {
        int dot = name.lastIndexOf(".");
        JavaFileObject.Kind kind = this.getKind(dot == -1 ? name : name.substring(dot));
        return fileKinds.contains((Object)kind);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, String name) throws IOException {
        Iterable path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        for (File root : path) {
            DefaultFileManager.Archive archive = this.myArchives.get(root);
            boolean isFile = archive != null ? true : this.isFile(root);
            if (isFile) {
                if (archive == null) {
                    try {
                        archive = this.openArchive(root);
                    }
                    catch (IOException ex) {
                        this.log.error("error.reading.file", root, ex.getLocalizedMessage());
                        break;
                    }
                }
                if (!archive.contains(name)) continue;
                int i = name.lastIndexOf(47);
                String dirname = name.substring(0, i + 1);
                String basename = name.substring(i + 1);
                return archive.getFileObject(dirname, basename);
            }
            File f = new File(root, name.replace('/', File.separatorChar));
            if (!f.exists()) continue;
            return new InputFileObject(f);
        }
        return null;
    }

    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        String relativePath = dot != -1 ? name.substring(0, dot) : name;
        return relativePath.replace(File.separatorChar, '.');
    }

    private static URI convertToURI(String localPath) throws URISyntaxException {
        String p = localPath.replace('\\', '/');
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.startsWith("//")) {
            p = "//" + p;
        }
        return new URI("file", null, p, null);
    }

    private ByteBuffer makeByteBuffer(InputStream in) throws IOException {
        int limit = in.available();
        if (limit < 1024) {
            limit = 1024;
        }
        ByteBuffer result = this.myByteBufferCache.get(limit);
        int position = 0;
        while (in.available() != 0) {
            int count;
            if (position >= limit) {
                result = ByteBuffer.allocate(limit <<= 1).put((ByteBuffer)result.flip());
            }
            if ((count = in.read(result.array(), position, limit - position)) < 0) break;
            result.position(position += count);
        }
        return (ByteBuffer)result.flip();
    }

    private CharBuffer decode(ByteBuffer inbuf, boolean ignoreEncodingErrors) {
        CoderResult result;
        CharsetDecoder decoder;
        String encodingName = this.getEncodingName();
        try {
            Charset charset = this.charset == null ? Charset.forName(encodingName) : this.charset;
            decoder = charset.newDecoder();
            CodingErrorAction action = ignoreEncodingErrors ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
            decoder.onMalformedInput(action).onUnmappableCharacter(action);
        }
        catch (IllegalCharsetNameException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        catch (UnsupportedCharsetException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float factor = decoder.averageCharsPerByte() * 0.8f + decoder.maxCharsPerByte() * 0.2f;
        CharBuffer dest = CharBuffer.allocate(10 + (int)((float)inbuf.remaining() * factor));
        while (true) {
            result = decoder.decode(inbuf, dest, true);
            dest.flip();
            if (result.isUnderflow()) {
                if (dest.limit() == dest.capacity()) {
                    dest = CharBuffer.allocate(dest.capacity() + 1).put(dest);
                    dest.flip();
                }
                return dest;
            }
            if (result.isOverflow()) {
                int newCapacity = 10 + dest.capacity() + (int)((float)inbuf.remaining() * decoder.maxCharsPerByte());
                dest = CharBuffer.allocate(newCapacity).put(dest);
                continue;
            }
            if (!result.isMalformed() && !result.isUnmappable()) break;
            if (!this.getSource().allowEncodingErrors()) {
                this.log.error(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", new Object[]{this.charset == null ? encodingName : this.charset.name()});
            } else {
                this.log.warning(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", new Object[]{this.charset == null ? encodingName : this.charset.name()});
            }
            inbuf.position(inbuf.position() + result.length());
            dest.position(dest.limit());
            dest.limit(dest.capacity());
            dest.put('\ufffd');
        }
        throw new AssertionError(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            super.close();
        }
        finally {
            if (ourUseContentCache) {
                this.myContentCache.clear();
            }
            this.myDirectoryCache.clear();
            this.myByteBufferCache.clear();
            this.myIsFile.clear();
            if (!ourPathCacheClearProblem) {
                try {
                    Paths.clearPathExistanceCache();
                }
                catch (Throwable ignored) {
                    ourPathCacheClearProblem = true;
                }
            }
        }
    }

    private static class ByteBufferCache {
        private AtomicReference<ByteBuffer> myCached = new AtomicReference<Object>(null);

        private ByteBufferCache() {
        }

        ByteBuffer get(int capacity) {
            ByteBuffer cached;
            if (capacity < 20480) {
                capacity = 20480;
            }
            return (cached = (ByteBuffer)this.myCached.getAndSet(null)) != null && cached.capacity() >= capacity ? (ByteBuffer)cached.clear() : ByteBuffer.allocate(capacity + capacity >> 1);
        }

        void put(ByteBuffer x) {
            this.myCached.set(x);
        }

        void clear() {
            this.myCached.set(null);
        }
    }

    private class InputFileObject
    extends BaseFileObject {
        final File f;

        public InputFileObject(File f) {
            this.f = f;
        }

        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.f);
        }

        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            throw new UnsupportedOperationException();
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public String getName() {
            return this.f.getPath();
        }

        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            String n = simpleName + kind.extension;
            String fileName = this.f.getName();
            if (fileName.equals(n)) {
                return true;
            }
            if (fileName.equalsIgnoreCase(n)) {
                try {
                    return this.f.getCanonicalFile().getName().equals(n);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return false;
        }

        @Deprecated
        public String getPath() {
            return this.f.getPath();
        }

        public long getLastModified() {
            return this.f.lastModified();
        }

        public boolean delete() {
            return this.f.delete();
        }

        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer cb;
            if (ourUseContentCache) {
                SoftReference ref = (SoftReference)OptimizedFileManager.this.myContentCache.get((Object)this);
                CharBuffer charBuffer = cb = ref != null ? (CharBuffer)ref.get() : null;
                if (cb == null) {
                    cb = this.loadFileContent(ignoreEncodingErrors);
                    if (!ignoreEncodingErrors) {
                        OptimizedFileManager.this.myContentCache.put(this, new SoftReference<CharBuffer>(cb));
                    }
                }
            } else {
                cb = this.loadFileContent(ignoreEncodingErrors);
            }
            return cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CharBuffer loadFileContent(boolean ignoreEncodingErrors) throws IOException {
            FileInputStream in = new FileInputStream(this.f);
            ByteBuffer bb = OptimizedFileManager.this.makeByteBuffer(in);
            JavaFileObject prev = OptimizedFileManager.this.log.useSource((JavaFileObject)((Object)this));
            try {
                CharBuffer charBuffer = OptimizedFileManager.this.decode(bb, ignoreEncodingErrors);
                return charBuffer;
            }
            finally {
                OptimizedFileManager.this.log.useSource(prev);
                OptimizedFileManager.this.myByteBufferCache.put(bb);
                ((InputStream)in).close();
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof InputFileObject)) {
                return false;
            }
            InputFileObject o = (InputFileObject)((Object)other);
            try {
                return this.f.equals(o.f) || this.f.getCanonicalFile().equals(o.f.getCanonicalFile());
            }
            catch (IOException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.f.hashCode();
        }

        public URI toUri() {
            try {
                return OptimizedFileManager.convertToURI(this.f.getPath());
            }
            catch (Throwable ex) {
                return this.f.toURI().normalize();
            }
        }
    }
}

