/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.engine.descriptor.ClassBasedContainerExtensionContext;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.LifecycleMethodUtils;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.ConditionEvaluator;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.execution.TestInstanceProvider;
import org.junit.jupiter.engine.execution.ThrowableCollector;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.JavaClassSource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public class ClassTestDescriptor
extends JupiterTestDescriptor {
    private static final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();
    private final Class<?> testClass;
    private final List<Method> beforeAllMethods;
    private final List<Method> afterAllMethods;
    private final List<Method> beforeEachMethods;
    private final List<Method> afterEachMethods;

    public ClassTestDescriptor(UniqueId uniqueId, Class<?> testClass) {
        this(uniqueId, ClassTestDescriptor::generateDefaultDisplayName, testClass);
    }

    protected ClassTestDescriptor(UniqueId uniqueId, Function<Class<?>, String> defaultDisplayNameGenerator, Class<?> testClass) {
        super(uniqueId, ClassTestDescriptor.determineDisplayName((AnnotatedElement)Preconditions.notNull(testClass, (String)"Class must not be null"), defaultDisplayNameGenerator));
        this.testClass = testClass;
        this.beforeAllMethods = LifecycleMethodUtils.findBeforeAllMethods(testClass);
        this.afterAllMethods = LifecycleMethodUtils.findAfterAllMethods(testClass);
        this.beforeEachMethods = LifecycleMethodUtils.findBeforeEachMethods(testClass);
        this.afterEachMethods = LifecycleMethodUtils.findAfterEachMethods(testClass);
        this.setSource((TestSource)new JavaClassSource(testClass));
    }

    public Set<TestTag> getTags() {
        return this.getTags(this.testClass);
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final boolean isTest() {
        return false;
    }

    public final boolean isContainer() {
        return true;
    }

    private static String generateDefaultDisplayName(Class<?> testClass) {
        String name = testClass.getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = this.populateNewExtensionRegistryFromExtendWith(this.testClass, context.getExtensionRegistry());
        this.registerBeforeEachMethodAdapters(registry);
        this.registerAfterEachMethodAdapters(registry);
        ClassBasedContainerExtensionContext containerExtensionContext = new ClassBasedContainerExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this);
        return context.extend().withTestInstanceProvider(this.testInstanceProvider(context, registry, containerExtensionContext)).withExtensionRegistry(registry).withExtensionContext(containerExtensionContext).withThrowableCollector(new ThrowableCollector()).build();
    }

    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) throws Exception {
        ConditionEvaluationResult evaluationResult = conditionEvaluator.evaluateForContainer(context.getExtensionRegistry(), context.getConfigurationParameters(), (ContainerExtensionContext)context.getExtensionContext());
        if (evaluationResult.isDisabled()) {
            return Node.SkipResult.skip((String)evaluationResult.getReason().orElse("<unknown>"));
        }
        return Node.SkipResult.doNotSkip();
    }

    public JupiterEngineExecutionContext before(JupiterEngineExecutionContext context) throws Exception {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        this.invokeBeforeAllCallbacks(context);
        if (throwableCollector.isEmpty()) {
            context.beforeAllMethodsExecuted(true);
            this.invokeBeforeAllMethods(context);
        }
        throwableCollector.assertEmpty();
        return context;
    }

    public void after(JupiterEngineExecutionContext context) throws Exception {
        if (context.beforeAllMethodsExecuted()) {
            this.invokeAfterAllMethods(context);
        }
        this.invokeAfterAllCallbacks(context);
        context.getThrowableCollector().assertEmpty();
    }

    protected TestInstanceProvider testInstanceProvider(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ExtensionContext extensionContext) {
        return () -> {
            Constructor constructor = ReflectionUtils.getDeclaredConstructor(this.testClass);
            Object instance = executableInvoker.invoke(constructor, extensionContext, registry);
            this.invokeTestInstancePostProcessors(instance, registry, extensionContext);
            return instance;
        };
    }

    protected void invokeTestInstancePostProcessors(Object instance, ExtensionRegistry registry, ExtensionContext context) {
        registry.stream(TestInstancePostProcessor.class).forEach(extension -> this.executeAndMaskThrowable(() -> extension.postProcessTestInstance(instance, context)));
    }

    private void invokeBeforeAllCallbacks(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ContainerExtensionContext extensionContext = (ContainerExtensionContext)context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (BeforeAllCallback callback : registry.getExtensions(BeforeAllCallback.class)) {
            throwableCollector.execute(() -> callback.beforeAll(extensionContext));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeBeforeAllMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ContainerExtensionContext extensionContext = (ContainerExtensionContext)context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (Method method : this.beforeAllMethods) {
            throwableCollector.execute(() -> executableInvoker.invoke(method, (ExtensionContext)extensionContext, registry));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeAfterAllMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ContainerExtensionContext extensionContext = (ContainerExtensionContext)context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        this.afterAllMethods.forEach(method -> throwableCollector.execute(() -> executableInvoker.invoke((Method)method, (ExtensionContext)extensionContext, registry)));
    }

    private void invokeAfterAllCallbacks(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ContainerExtensionContext extensionContext = (ContainerExtensionContext)context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        registry.getReversedExtensions(AfterAllCallback.class).forEach(extension -> throwableCollector.execute(() -> extension.afterAll(extensionContext)));
    }

    private void registerBeforeEachMethodAdapters(ExtensionRegistry registry) {
        this.registerMethodsAsExtensions(this.beforeEachMethods, registry, this::synthesizeBeforeEachMethodAdapter);
    }

    private void registerAfterEachMethodAdapters(ExtensionRegistry registry) {
        this.registerMethodsAsExtensions(this.afterEachMethods, registry, this::synthesizeAfterEachMethodAdapter);
    }

    private void registerMethodsAsExtensions(List<Method> methods, ExtensionRegistry registry, BiFunction<ExtensionRegistry, Method, Extension> extensionSynthesizer) {
        methods.forEach(method -> registry.registerExtension((Extension)extensionSynthesizer.apply(registry, (Method)method), method));
    }

    private BeforeEachMethodAdapter synthesizeBeforeEachMethodAdapter(ExtensionRegistry registry, Method method) {
        return extensionContext -> this.invokeMethodInTestExtensionContext(method, extensionContext, registry);
    }

    private AfterEachMethodAdapter synthesizeAfterEachMethodAdapter(ExtensionRegistry registry, Method method) {
        return extensionContext -> this.invokeMethodInTestExtensionContext(method, extensionContext, registry);
    }

    private void invokeMethodInTestExtensionContext(Method method, TestExtensionContext context, ExtensionRegistry registry) {
        Object instance = ReflectionUtils.getOuterInstance((Object)context.getTestInstance(), method.getDeclaringClass()).orElseThrow(() -> new JUnitException("Failed to find instance for method: " + method.toGenericString()));
        executableInvoker.invoke(method, instance, (ExtensionContext)context, registry);
    }
}

