/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.io.File;
import java.util.HashSet;
import java.util.function.Predicate;
import org.junit.jupiter.engine.discovery.ElementResolver;
import org.junit.jupiter.engine.discovery.JavaElementsResolver;
import org.junit.jupiter.engine.discovery.NestedTestsResolver;
import org.junit.jupiter.engine.discovery.TestContainerResolver;
import org.junit.jupiter.engine.discovery.TestFactoryMethodResolver;
import org.junit.jupiter.engine.discovery.TestMethodResolver;
import org.junit.jupiter.engine.discovery.predicates.IsScannableTestClass;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;

@API(value=API.Usage.Experimental)
public class DiscoverySelectorResolver {
    private static final IsScannableTestClass isScannableTestClass = new IsScannableTestClass();

    public void resolveSelectors(EngineDiscoveryRequest request, TestDescriptor engineDescriptor) {
        JavaElementsResolver javaElementsResolver = this.createJavaElementsResolver(engineDescriptor);
        request.getSelectorsByType(ClasspathSelector.class).forEach(selector -> ReflectionUtils.findAllClassesInClasspathRoot((File)selector.getClasspathRoot(), (Predicate)isScannableTestClass).forEach(javaElementsResolver::resolveClass));
        request.getSelectorsByType(PackageSelector.class).forEach(selector -> ReflectionUtils.findAllClassesInPackage((String)selector.getPackageName(), (Predicate)isScannableTestClass).forEach(javaElementsResolver::resolveClass));
        request.getSelectorsByType(ClassSelector.class).forEach(selector -> javaElementsResolver.resolveClass(selector.getJavaClass()));
        request.getSelectorsByType(MethodSelector.class).forEach(selector -> javaElementsResolver.resolveMethod(selector.getJavaClass(), selector.getJavaMethod()));
        request.getSelectorsByType(UniqueIdSelector.class).forEach(selector -> javaElementsResolver.resolveUniqueId(selector.getUniqueId()));
        this.pruneTree(engineDescriptor);
    }

    private JavaElementsResolver createJavaElementsResolver(TestDescriptor engineDescriptor) {
        HashSet<ElementResolver> resolvers = new HashSet<ElementResolver>();
        resolvers.add(new TestContainerResolver());
        resolvers.add(new NestedTestsResolver());
        resolvers.add(new TestMethodResolver());
        resolvers.add(new TestFactoryMethodResolver());
        return new JavaElementsResolver(engineDescriptor, resolvers);
    }

    private void pruneTree(TestDescriptor root) {
        TestDescriptor.Visitor removeChildrenWithoutTests = descriptor -> {
            if (!descriptor.isRoot() && !descriptor.hasTests()) {
                descriptor.removeFromHierarchy();
            }
        };
        root.accept(removeChildrenWithoutTests);
    }
}

