/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.util.function.Predicate;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
public class IsPotentialTestContainer
implements Predicate<Class<?>> {
    @Override
    public boolean test(Class<?> candidate) {
        if (ReflectionUtils.isAbstract(candidate)) {
            return false;
        }
        if (candidate.isLocalClass()) {
            return false;
        }
        if (candidate.isAnonymousClass()) {
            return false;
        }
        return ReflectionUtils.isStatic(candidate) || !candidate.isMemberClass();
    }
}

