/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.ide.common.util.AssetUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TextRenderUtil {
    public static BufferedImage renderTextImage(String text, int paddingPercentage, Options options) {
        if (options == null) {
            options = new Options();
        }
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)1, (int)1);
        if (text == null || text.isEmpty()) {
            return tempImage;
        }
        Graphics2D tempG = (Graphics2D)tempImage.getGraphics();
        Font font = options.font;
        if (font == null) {
            font = new Font(options.fontName, options.fontStyle, options.fontSize);
        }
        FontRenderContext frc = tempG.getFontRenderContext();
        TextLayout layout = new TextLayout(text, font, frc);
        Rectangle2D bounds = layout.getBounds();
        if (paddingPercentage != 0) {
            double minDimension = Math.min(bounds.getWidth(), bounds.getHeight());
            double delta = minDimension * (double)paddingPercentage / 100.0;
            bounds.setRect(bounds.getMinX() - delta, bounds.getMinY() - delta, bounds.getWidth() + 2.0 * delta, bounds.getHeight() + 2.0 * delta);
        }
        BufferedImage image = AssetUtil.newArgbBufferedImage((int)Math.max(1, (int)bounds.getWidth()), (int)Math.max(1, (int)bounds.getHeight()));
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(new Color(options.foregroundColor, true));
        g.setFont(font);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.drawString(text, (float)(-bounds.getX()), (float)(-bounds.getY()));
        g.dispose();
        tempG.dispose();
        return image;
    }

    public static class Options {
        private static final int DEFAULT_FONT_SIZE = 512;
        public int foregroundColor = -1;
        public Font font = null;
        public String fontName = "Serif";
        public int fontStyle = 0;
        public int fontSize = 512;
    }
}

