/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class LocaleDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue STRING_LOCALE = Issue.create("DefaultLocale", "Implied default locale in case conversion", "Calling `String#toLowerCase()` or `#toUpperCase()` *without specifying an explicit locale* is a common source of bugs. The reason for that is that those methods will use the current locale on the user's device, and even though the code appears to work correctly when you are developing the app, it will fail in some locales. For example, in the Turkish locale, the uppercase replacement for `i` is *not* `I`.\n\nIf you want the methods to just perform ASCII replacement, for example to convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you really want to use the current locale, call `String#toUpperCase(Locale.getDefault())` instead.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/java/util/Locale.html#default_locale");

    @Override
    public List<String> getApplicableMethodNames() {
        if (LintClient.isStudio()) {
            return Collections.singletonList("format");
        }
        return Arrays.asList("toLowerCase", "toUpperCase", "format");
    }

    @Override
    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation call) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedNode resolved = context.resolve((Node)call);
        if (resolved instanceof JavaParser.ResolvedMethod && (method = (JavaParser.ResolvedMethod)resolved).getContainingClass().matches("java.lang.String")) {
            String name = method.getName();
            if (name.equals("format")) {
                LocaleDetector.checkFormat(context, method, call);
            } else if (method.getArgumentCount() == 0) {
                Location location = context.getNameLocation((Node)call);
                String message = String.format("Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead", name);
                context.report(STRING_LOCALE, (Node)call, location, message);
            }
        }
    }

    private static boolean isLoggingParameter(JavaContext context, MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedNode resolved;
        MethodInvocation call;
        String name;
        Node parent = node.getParent();
        return parent instanceof MethodInvocation && (name = (call = (MethodInvocation)parent).astName().astValue()).length() == 1 && (resolved = context.resolve((Node)call)) instanceof JavaParser.ResolvedMethod && (method = (JavaParser.ResolvedMethod)resolved).getContainingClass().matches("android.util.Log");
    }

    private static void checkFormat(JavaContext context, JavaParser.ResolvedMethod method, MethodInvocation call) {
        if (method.getArgumentCount() == 0 || !method.getArgumentType(0).matchesName("java.lang.String") || call.astArguments().isEmpty()) {
            return;
        }
        Expression first = (Expression)call.astArguments().first();
        Object value = ConstantEvaluator.evaluate(context, (Node)first);
        if (!(value instanceof String)) {
            return;
        }
        String format = (String)value;
        if (StringFormatDetector.isLocaleSpecific(format)) {
            if (LocaleDetector.isLoggingParameter(context, call)) {
                return;
            }
            Location location = context.getLocation((Node)call);
            String message = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
            context.report(STRING_LOCALE, (Node)call, location, message);
        }
    }
}

