/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalysisResultEntry;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzerTask;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DuplicatedStringsAnalyzerTask
extends MemoryAnalyzerTask {
    @Override
    List<AnalysisResultEntry> analyze(MemoryAnalyzerTask.Configuration configuration, Snapshot snapshot) {
        ArrayList<AnalysisResultEntry> results = new ArrayList<AnalysisResultEntry>();
        HashMultimap stringIndex = HashMultimap.create();
        ClassObj stringClass = snapshot.findClass("java.lang.String");
        if (stringClass == null) {
            return Collections.emptyList();
        }
        for (Heap heap : configuration.mHeaps) {
            List<Instance> instances = stringClass.getHeapInstances(heap.getId());
            for (Instance instance : instances) {
                char[] characters;
                assert (instance instanceof ClassInstance);
                ClassInstance stringInstance = (ClassInstance)instance;
                if (stringInstance.getDistanceToGcRoot() == Integer.MAX_VALUE || (characters = stringInstance.getStringChars()) == null) continue;
                String string = new String(characters);
                stringIndex.put((Object)string, (Object)stringInstance);
            }
        }
        for (String key : stringIndex.keySet()) {
            Set classInstanceSet = stringIndex.get((Object)key);
            if (classInstanceSet.size() <= 1) continue;
            results.add(new DuplicatedStringsEntry(key, new ArrayList(classInstanceSet)));
        }
        return results;
    }

    @Override
    public String getTaskName() {
        return "Find Duplicate Strings";
    }

    @Override
    public String getTaskDescription() {
        return "Detects duplicate strings in the application.";
    }

    public static class DuplicatedStringsEntry
    extends MemoryAnalysisResultEntry {
        private DuplicatedStringsEntry(String offendingString, List<Instance> duplicates) {
            super(offendingString, duplicates);
        }

        @Override
        public String getWarningMessage() {
            return String.format("%d instances: \"%s\"", this.mOffender.getOffenders().size(), this.mOffender.getOffendingDescription());
        }

        @Override
        public String getCategory() {
            return "Duplicated Strings";
        }
    }
}

