/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import org.intellij.lang.regexp.RegExpFileType;
import org.jetbrains.annotations.NotNull;

public enum ResponseType {
    XML("application/xml", (FileType)XmlFileType.INSTANCE, ResponseType.findXPathFileType()),
    JSON("application/json", ResponseType.findFileTypePlainDefault("JSON"), (FileType)PlainTextFileType.INSTANCE),
    HTML("text/html", (FileType)HtmlFileType.INSTANCE, (FileType)PlainTextFileType.INSTANCE),
    TEXT("text/plain", (FileType)PlainTextFileType.INSTANCE, (FileType)RegExpFileType.INSTANCE);

    private final String myMimeType;
    private final FileType myContentFileType;
    private final FileType mySelectorFileType;
    private static Logger LOG;

    private ResponseType(@NotNull String s, FileType contentFileType, FileType selectorFileType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/tasks/generic/ResponseType", "<init>"));
        }
        if (contentFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFileType", "com/intellij/tasks/generic/ResponseType", "<init>"));
        }
        if (selectorFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorFileType", "com/intellij/tasks/generic/ResponseType", "<init>"));
        }
        this.myMimeType = s;
        this.myContentFileType = contentFileType;
        this.mySelectorFileType = selectorFileType;
    }

    @NotNull
    private static FileType findFileTypePlainDefault(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tasks/generic/ResponseType", "findFileTypePlainDefault"));
        }
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName(name);
        Object object = fileType == null ? PlainTextFileType.INSTANCE : fileType;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/ResponseType", "findFileTypePlainDefault"));
        }
        return object;
    }

    @NotNull
    private static FileType findXPathFileType() {
        FileType fileType;
        if (LOG == null) {
            LOG = Logger.getInstance(ResponseType.class);
        }
        try {
            Class<?> xPathClass = Class.forName("org.intellij.lang.xpath.XPathFileType");
            LOG.debug("XPathFileType class loaded successfully");
            fileType = (FileType)xPathClass.getField("XPATH").get(null);
        }
        catch (Exception e) {
            LOG.debug("XPathFileType class not found. Using PlainText.INSTANCE instead");
            PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
            if (plainTextFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/ResponseType", "findXPathFileType"));
            }
            return plainTextFileType;
        }
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/ResponseType", "findXPathFileType"));
        }
        return fileType;
    }

    @NotNull
    public String getMimeType() {
        String string = this.myMimeType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/ResponseType", "getMimeType"));
        }
        return string;
    }

    @NotNull
    public FileType getContentFileType() {
        FileType fileType = this.myContentFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/ResponseType", "getContentFileType"));
        }
        return fileType;
    }

    @NotNull
    public FileType getSelectorFileType() {
        FileType fileType = this.mySelectorFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/ResponseType", "getSelectorFileType"));
        }
        return fileType;
    }

    static {
        LOG = Logger.getInstance(ResponseType.class);
    }
}

