/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.generic.SelectorBasedResponseHandler;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="XPathResponseHandler")
public final class XPathResponseHandler
extends SelectorBasedResponseHandler {
    private final Map<String, XPath> myCompiledCache = new HashMap();

    public XPathResponseHandler() {
    }

    public XPathResponseHandler(GenericRepository repository) {
        super(repository);
    }

    @Override
    @NotNull
    protected List<Object> selectTasksList(@NotNull String response, int max) throws Exception {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/intellij/tasks/generic/XPathResponseHandler", "selectTasksList"));
        }
        Document document = new SAXBuilder(false).build((Reader)new StringReader(response));
        Element root = document.getRootElement();
        XPath xPath = this.lazyCompile(this.getSelector("tasks").getPath());
        List rawTaskElements = xPath.selectNodes((Object)root);
        if (!rawTaskElements.isEmpty() && !(rawTaskElements.get(0) instanceof Element)) {
            throw new Exception(String.format("Expression '%s' should match list of XML elements. Got '%s' instead.", xPath.getXPath(), rawTaskElements.toString()));
        }
        List<Object> list = rawTaskElements.subList(0, Math.min(rawTaskElements.size(), max));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/XPathResponseHandler", "selectTasksList"));
        }
        return list;
    }

    @Override
    @Nullable
    protected String selectString(@NotNull Selector selector, @NotNull Object context) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/tasks/generic/XPathResponseHandler", "selectString"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tasks/generic/XPathResponseHandler", "selectString"));
        }
        if (StringUtil.isEmpty((String)selector.getPath())) {
            return null;
        }
        XPath xPath = this.lazyCompile(selector.getPath());
        String s = xPath.valueOf(context);
        if (s == null) {
            throw new Exception(String.format("XPath expression '%s' doesn't match", xPath.getXPath()));
        }
        return s;
    }

    @NotNull
    private XPath lazyCompile(@NotNull String path) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/tasks/generic/XPathResponseHandler", "lazyCompile"));
        }
        XPath xPath = this.myCompiledCache.get(path);
        if (xPath == null) {
            try {
                xPath = XPath.newInstance((String)path);
                this.myCompiledCache.put(path, xPath);
            }
            catch (JDOMException e) {
                throw new Exception(String.format("Malformed XPath expression '%s'", path));
            }
        }
        XPath xPath2 = xPath;
        if (xPath2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/XPathResponseHandler", "lazyCompile"));
        }
        return xPath2;
    }

    @Override
    @NotNull
    public ResponseType getResponseType() {
        ResponseType responseType = ResponseType.XML;
        if (responseType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/XPathResponseHandler", "getResponseType"));
        }
        return responseType;
    }
}

