/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

public class GenerateComponentExternalizationAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.actions.GenerateComponentExternalizationAction");
    @NonNls
    private static final String BASE_COMPONENT = "com.intellij.openapi.components.BaseComponent";
    @NonNls
    private static final String PERSISTENCE_STATE_COMPONENT = "com.intellij.openapi.components.PersistentStateComponent";
    @NonNls
    private static final String STATE = "com.intellij.openapi.components.State";
    @NonNls
    private static final String STORAGE = "com.intellij.openapi.components.Storage";

    public void actionPerformed(AnActionEvent e) {
        PsiClass target = this.getComponentInContext(e.getDataContext());
        assert (target != null);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)target.getProject()).getElementFactory();
        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)target.getManager().getProject());
        JavaCodeStyleManager styler = JavaCodeStyleManager.getInstance((Project)target.getProject());
        String qualifiedName = target.getQualifiedName();
        Runnable runnable = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                PsiReferenceList implList = target.getImplementsList();
                assert (implList != null);
                PsiJavaCodeReferenceElement referenceElement = factory.createReferenceFromText("com.intellij.openapi.components.PersistentStateComponent<" + qualifiedName + ">", (PsiElement)target);
                implList.add(styler.shortenClassReferences(referenceElement.copy()));
                PsiMethod read = factory.createMethodFromText("public void loadState(" + qualifiedName + " state) {\n    com.intellij.util.xmlb.XmlSerializerUtil.copyBean(state, this);\n}", (PsiElement)target);
                read = (PsiMethod)formatter.reformat(target.add((PsiElement)read));
                styler.shortenClassReferences((PsiElement)read);
                PsiMethod write = factory.createMethodFromText("public " + qualifiedName + " getState() {\n    return this;\n}\n", (PsiElement)target);
                write = (PsiMethod)formatter.reformat(target.add((PsiElement)write));
                styler.shortenClassReferences((PsiElement)write);
                PsiAnnotation annotation = target.getModifierList().addAnnotation(STATE);
                annotation = (PsiAnnotation)formatter.reformat(annotation.replace((PsiElement)factory.createAnnotationFromText("@com.intellij.openapi.components.State(name = \"" + qualifiedName + "\", storages = {@" + STORAGE + "(file = \"" + "$WORKSPACE_FILE$" + "\"\n )})", (PsiElement)target)));
                styler.shortenClassReferences((PsiElement)annotation);
            }
            catch (IncorrectOperationException e1) {
                LOG.error((Throwable)e1);
            }
        });
        CommandProcessor.getInstance().executeCommand(target.getProject(), runnable, DevKitBundle.message("command.implement.externalizable", new Object[0]), null);
    }

    @Nullable
    private PsiClass getComponentInContext(DataContext context) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (editor == null || project == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (file == null) {
            return null;
        }
        PsiClass contextClass = (PsiClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PsiClass.class, (boolean)false);
        if (contextClass == null || contextClass.isEnum() || contextClass.isInterface() || contextClass instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass componentClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(BASE_COMPONENT, file.getResolveScope());
        if (componentClass == null || !contextClass.isInheritor(componentClass, true)) {
            return null;
        }
        PsiClass externClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(PERSISTENCE_STATE_COMPONENT, file.getResolveScope());
        if (externClass == null || contextClass.isInheritor(externClass, true)) {
            return null;
        }
        return contextClass;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        PsiClass target = this.getComponentInContext(e.getDataContext());
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(target != null);
        presentation.setVisible(target != null);
    }
}

