/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public abstract class ExtensionPointImpl
implements ExtensionPoint {
    @Override
    @NotNull
    public String getEffectiveName() {
        if (DomUtil.hasXml(this.getName())) {
            String string = this.getName().getRawText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/ExtensionPointImpl", "getEffectiveName"));
            }
            return string;
        }
        String string = this.getQualifiedName().getRawText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/ExtensionPointImpl", "getEffectiveName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getNamePrefix() {
        if (DomUtil.hasXml(this.getQualifiedName())) {
            return null;
        }
        IdeaPlugin plugin = (IdeaPlugin)this.getParentOfType(IdeaPlugin.class, false);
        if (plugin == null) {
            return null;
        }
        return StringUtil.notNullize((String)plugin.getPluginId(), (String)"com.intellij");
    }

    @Override
    @NotNull
    public String getEffectiveQualifiedName() {
        if (DomUtil.hasXml(this.getQualifiedName())) {
            String string = this.getQualifiedName().getRawText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/ExtensionPointImpl", "getEffectiveQualifiedName"));
            }
            return string;
        }
        String string = this.getNamePrefix() + "." + this.getName().getRawText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/ExtensionPointImpl", "getEffectiveQualifiedName"));
        }
        return string;
    }
}

