/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class StubBasedPsiElementBaseGetParentInspection
extends DevKitInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection", "checkClass"));
        }
        if (psiClass.isInterface() || psiClass.isEnum() || !psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("static") || psiClass.hasModifierProperty("abstract") || psiClass.getContainingClass() != null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)StubBasedPsiElementBase.class.getName())) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        LightMethodBuilder myParentTemplate = StubBasedPsiElementBaseGetParentInspection.createGetParentTemplateMethod(psiClass);
        PsiMethod overriddenGetParentMethod = psiClass.findMethodBySignature((PsiMethod)myParentTemplate, true);
        if (overriddenGetParentMethod != null && overriddenGetParentMethod.getContainingClass() != null && !StubBasedPsiElementBase.class.getName().equals(overriddenGetParentMethod.getContainingClass().getQualifiedName())) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)ObjectUtils.assertNotNull((Object)psiClass.getNameIdentifier()), "Default getParent() implementation is slow", (LocalQuickFix)new InsertGetParentByStubOverrideQuickFix(psiClass, isOnTheFly), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
        return new ProblemDescriptor[]{descriptor};
    }

    private static LightMethodBuilder createGetParentTemplateMethod(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection", "createGetParentTemplateMethod"));
        }
        return new LightMethodBuilder(psiClass.getManager(), "getParent").setMethodReturnType(PsiElement.class.getName());
    }

    private static class InsertGetParentByStubOverrideQuickFix
    extends LocalQuickFixOnPsiElement {
        private final boolean myOnTheFly;

        private InsertGetParentByStubOverrideQuickFix(@NotNull PsiClass psiClass, boolean isOnTheFly) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection$InsertGetParentByStubOverrideQuickFix", "<init>"));
            }
            super((PsiElement)psiClass);
            this.myOnTheFly = isOnTheFly;
        }

        @NotNull
        public String getText() {
            if ("Override with calling getParentByStub()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection$InsertGetParentByStubOverrideQuickFix", "getText"));
            }
            return "Override with calling getParentByStub()";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection$InsertGetParentByStubOverrideQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiGenerationInfo item;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection$InsertGetParentByStubOverrideQuickFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection$InsertGetParentByStubOverrideQuickFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection$InsertGetParentByStubOverrideQuickFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/idea/devkit/inspections/StubBasedPsiElementBaseGetParentInspection$InsertGetParentByStubOverrideQuickFix", "invoke"));
            }
            if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file.getVirtualFile()})) {
                return;
            }
            PsiClass psiClass = (PsiClass)startElement;
            PsiClass stubBasedPsiElementClass = JavaPsiFacade.getInstance((Project)project).findClass(StubBasedPsiElementBase.class.getName(), psiClass.getResolveScope());
            assert (stubBasedPsiElementClass != null);
            PsiMethod methodToOverride = stubBasedPsiElementClass.findMethodBySignature((PsiMethod)StubBasedPsiElementBaseGetParentInspection.createGetParentTemplateMethod(stubBasedPsiElementClass), false);
            List methods = OverrideImplementUtil.overrideOrImplementMethod((PsiClass)psiClass, (PsiMethod)methodToOverride, (boolean)false);
            if (methods.size() != 1) {
                return;
            }
            PsiMethod getParentMethod = (PsiMethod)ContainerUtil.getFirstItem((List)methods);
            assert (getParentMethod != null);
            PsiCodeBlock originalCodeBlock = getParentMethod.getBody();
            assert (originalCodeBlock != null);
            PsiCodeBlock optimizedCodeBlock = JavaPsiFacade.getElementFactory((Project)project).createCodeBlockFromText("{ return getParentByStub(); }", (PsiElement)getParentMethod);
            originalCodeBlock.replace((PsiElement)optimizedCodeBlock);
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)stubBasedPsiElementClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement((PsiClass)psiClass, (PsiMethod)methodToOverride, (PsiSubstitutor)substitutor);
            List generationInfos = GenerateMembersUtil.insertMembersBeforeAnchor((PsiClass)psiClass, (PsiElement)anchor, Collections.singletonList(new PsiGenerationInfo((PsiMember)getParentMethod)));
            if (this.myOnTheFly && (item = (PsiGenerationInfo)ContainerUtil.getFirstItem((List)generationInfos)) != null) {
                PsiNavigateUtil.navigate((PsiElement)item.getPsiMember());
            }
        }
    }
}

