/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateHtmlDescriptionFix
implements LocalQuickFix,
Iconable {
    @NonNls
    private static final String TEMPLATE_NAME = "InspectionDescription.html";
    private final String myFilename;
    private final Module myModule;
    private final DescriptionType myDescriptionType;

    public CreateHtmlDescriptionFix(String filename, Module module, DescriptionType descriptionType) {
        this.myModule = module;
        this.myDescriptionType = descriptionType;
        this.myFilename = this.getNormalizedFileName(filename);
    }

    private boolean isFixedDescriptionFilename() {
        return this.myDescriptionType.isFixedDescriptionFilename();
    }

    private static List<VirtualFile> getPotentialRoots(Module module, PsiDirectory[] dirs) {
        if (dirs.length != 0) {
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            for (PsiDirectory dir : dirs) {
                PsiDirectory parent = dir.getParentDirectory();
                if (parent == null) continue;
                result.add(parent.getVirtualFile());
            }
            return result;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        List resourceRoots = rootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (!resourceRoots.isEmpty()) {
            return resourceRoots;
        }
        return rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
    }

    private String getNormalizedFileName(String filename) {
        return this.myDescriptionType.isFixedDescriptionFilename() ? filename : filename + ".html";
    }

    @NotNull
    public String getName() {
        String string = DevKitBundle.message("create.description.file", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("DevKit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "getFamilyName"));
        }
        return "DevKit";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/quickfix/CreateHtmlDescriptionFix", "applyFix"));
        }
        PsiDirectory[] dirs = this.getDirectories();
        List<VirtualFile> virtualFiles = CreateHtmlDescriptionFix.getPotentialRoots(this.myModule, dirs);
        VirtualFile[] roots = this.prepare(VfsUtilCore.toVirtualFileArray(virtualFiles));
        if (roots.length == 1) {
            ApplicationManager.getApplication().runWriteAction(() -> this.createDescription(roots[0]));
        } else {
            ArrayList<String> options = new ArrayList<String>();
            for (VirtualFile file : roots) {
                String path = this.getPath(file);
                options.add(path);
            }
            JBList files = new JBList((Object[])ArrayUtil.toStringArray(options));
            files.setSelectionMode(0);
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)files).setTitle(DevKitBundle.message("select.target.location.of.description", this.myFilename)).setItemChoosenCallback(() -> {
                int index = files.getSelectedIndex();
                if (0 <= index && index < roots.length) {
                    ApplicationManager.getApplication().runWriteAction(() -> this.createDescription(roots[index]));
                }
            }).createPopup();
            Editor editor = FileEditorManager.getInstance((Project)this.myModule.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            popup.showInBestPositionFor(editor);
        }
    }

    private String getPath(VirtualFile file) {
        String path = file.getPresentableUrl() + File.separator + this.getDescriptionFolderName() + File.separator + this.myFilename;
        if (this.isFixedDescriptionFilename()) {
            path = path + File.separator + "description.html";
        }
        return path;
    }

    private PsiDirectory[] getDirectories() {
        return DescriptionCheckerUtil.getDescriptionsDirs(this.myModule, this.myDescriptionType);
    }

    private void createDescription(VirtualFile root) {
        if (!root.isDirectory()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        PsiDirectory psiRoot = psiManager.findDirectory(root);
        PsiDirectory descrRoot = null;
        if (psiRoot == null) {
            return;
        }
        for (PsiDirectory dir : psiRoot.getSubdirectories()) {
            if (!this.getDescriptionFolderName().equals(dir.getName())) continue;
            descrRoot = dir;
            break;
        }
        try {
            VirtualFile file;
            FileTemplate descrTemplate;
            PsiElement template;
            PsiDirectory dir;
            PsiDirectory psiDirectory = descrRoot = descrRoot == null ? psiRoot.createSubdirectory(this.getDescriptionFolderName()) : descrRoot;
            if (this.isFixedDescriptionFilename() && (dir = descrRoot.findSubdirectory(this.myFilename)) == null) {
                descrRoot = descrRoot.createSubdirectory(this.myFilename);
            }
            if ((template = FileTemplateUtil.createFromTemplate((FileTemplate)(descrTemplate = FileTemplateManager.getInstance((Project)this.myModule.getProject()).getJ2eeTemplate(TEMPLATE_NAME)), (String)this.getNewFileName(), null, (PsiDirectory)descrRoot)) instanceof PsiFile && (file = ((PsiFile)template).getVirtualFile()) != null) {
                FileEditorManager.getInstance((Project)this.myModule.getProject()).openFile(file, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getNewFileName() {
        return this.isFixedDescriptionFilename() ? "description.html" : this.myFilename;
    }

    public Icon getIcon(int flags) {
        return new LayeredIcon(new Icon[]{AllIcons.FileTypes.Html, AllIcons.Actions.New});
    }

    private VirtualFile[] prepare(VirtualFile[] roots) {
        ArrayList<VirtualFile> found = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            if (!this.containsDescriptionDir(root)) continue;
            found.add(root);
        }
        return found.size() > 0 ? VfsUtilCore.toVirtualFileArray(found) : roots;
    }

    private boolean containsDescriptionDir(VirtualFile root) {
        if (!root.isDirectory()) {
            return false;
        }
        for (VirtualFile file : root.getChildren()) {
            if (!file.isDirectory() || !this.getDescriptionFolderName().equals(file.getName())) continue;
            return true;
        }
        return false;
    }

    private String getDescriptionFolderName() {
        return this.myDescriptionType.getDescriptionFolder();
    }
}

