/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.reference.UnusedDeclarationFixProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterExtensionFix;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterInspectionFix;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

public class RegisterExtensionFixProvider
implements UnusedDeclarationFixProvider {
    @NotNull
    public IntentionAction[] getQuickFixes(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
        }
        if (!(element instanceof PsiIdentifier)) {
            if (IntentionAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass)) {
            if (IntentionAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        PsiClass psiClass = (PsiClass)parent;
        if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)LocalInspectionTool.class.getName())) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{new RegisterInspectionFix(psiClass, (ExtensionPointName<? extends InspectionEP>)LocalInspectionEP.LOCAL_INSPECTION)};
            if (intentionActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return intentionActionArray;
        }
        if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)GlobalInspectionTool.class.getName())) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{new RegisterInspectionFix(psiClass, (ExtensionPointName<? extends InspectionEP>)InspectionEP.GLOBAL_INSPECTION)};
            if (intentionActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return intentionActionArray;
        }
        ExtensionPointLocator extensionPointLocator = new ExtensionPointLocator(psiClass);
        List<ExtensionPointCandidate> candidateList = extensionPointLocator.findSuperCandidates();
        if (!candidateList.isEmpty()) {
            IntentionAction[] intentionActionArray = new IntentionAction[]{new RegisterExtensionFix(psiClass, candidateList)};
            if (intentionActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
            }
            return intentionActionArray;
        }
        if (IntentionAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFixProvider", "getQuickFixes"));
        }
        return IntentionAction.EMPTY_ARRAY;
    }
}

