/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;

class RegisterInspectionFix
implements IntentionAction {
    private final PsiClass myPsiClass;
    private final ExtensionPointName<? extends InspectionEP> myEp;

    RegisterInspectionFix(PsiClass psiClass, ExtensionPointName<? extends InspectionEP> ep) {
        this.myPsiClass = psiClass;
        this.myEp = ep;
    }

    @NotNull
    public String getText() {
        if ("Register inspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "getText"));
        }
        return "Register inspection";
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.component.not.registered.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "isAvailable"));
        }
        return !DumbService.isDumb((Project)project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "invoke"));
        }
        PluginDescriptorChooser.show(project, editor, file, (Consumer<DomFileElement<IdeaPlugin>>)((Consumer)element -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix", "lambda$invoke$0"));
            }
            this.doFix((DomFileElement<IdeaPlugin>)element, project, file);
        }));
    }

    private void doFix(final DomFileElement<IdeaPlugin> selectedValue, Project project, PsiFile file) {
        Extension extension = (Extension)new WriteCommandAction<Extension>(project, new PsiFile[]{file}){

            protected void run(@NotNull Result<Extension> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterInspectionFix$1", "run"));
                }
                Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<IdeaPlugin>)selectedValue, RegisterInspectionFix.this.myEp.getName());
                Extension extension = extensions.addExtension(RegisterInspectionFix.this.myEp.getName());
                XmlTag tag = extension.getXmlTag();
                tag.setAttribute("implementationClass", RegisterInspectionFix.this.myPsiClass.getQualifiedName());
                result.setResult((Object)extension);
            }
        }.execute().throwException().getResultObject();
        PsiNavigateUtil.navigate((PsiElement)extension.getXmlTag());
    }

    public boolean startInWriteAction() {
        return false;
    }
}

