/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

@Presentation(icon="AllIcons.Nodes.TestSourceFolder")
public class TestDataGroupVirtualFile
extends VirtualFile {
    private final VirtualFile myBeforeFile;
    private final VirtualFile myAfterFile;

    public TestDataGroupVirtualFile(@NotNull VirtualFile beforeFile, @NotNull VirtualFile afterFile) {
        if (beforeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFile", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "<init>"));
        }
        if (afterFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFile", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "<init>"));
        }
        this.myBeforeFile = beforeFile;
        this.myAfterFile = afterFile;
    }

    @NotNull
    public String getName() {
        String prefix = StringUtil.commonPrefix((String)this.myBeforeFile.getName(), (String)this.myAfterFile.getName());
        if (prefix.isEmpty()) {
            String string = StringUtil.commonSuffix((String)this.myBeforeFile.getName(), (String)this.myAfterFile.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getName"));
            }
            return string;
        }
        String string = prefix + "." + this.myBeforeFile.getExtension();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getName"));
        }
        return string;
    }

    public VirtualFile getBeforeFile() {
        return this.myBeforeFile;
    }

    public VirtualFile getAfterFile() {
        return this.myAfterFile;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getFileSystem"));
        }
        return localFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myBeforeFile.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getPath"));
        }
        return string;
    }

    public boolean isWritable() {
        return this.myBeforeFile.isWritable();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return this.myBeforeFile.isValid() && this.myAfterFile.isValid();
    }

    public VirtualFile getParent() {
        return this.myBeforeFile.getParent();
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "contentsToByteArray"));
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public long getTimeStamp() {
        return this.myBeforeFile.getTimeStamp();
    }

    public long getLength() {
        return this.myBeforeFile.getLength();
    }

    public long getModificationStamp() {
        return this.myBeforeFile.getModificationStamp();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myBeforeFile.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getFileType"));
        }
        return fileType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TestDataGroupVirtualFile file = (TestDataGroupVirtualFile)((Object)o);
        if (!this.myAfterFile.equals(file.myAfterFile)) {
            return false;
        }
        return this.myBeforeFile.equals(file.myBeforeFile);
    }

    public int hashCode() {
        int result = this.myBeforeFile.hashCode();
        result = 31 * result + this.myAfterFile.hashCode();
        return result;
    }
}

