/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationHandler;

public class TestDataRelatedItem
extends GotoRelatedItem {
    private final List<String> myTestDataFiles;
    private final Editor myEditor;
    private final PsiMethod myMethod;

    public TestDataRelatedItem(@NotNull PsiMethod method, @NotNull Editor editor, @NotNull Collection<String> testDataFiles) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataRelatedItem", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/idea/devkit/testAssistant/TestDataRelatedItem", "<init>"));
        }
        if (testDataFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDataFiles", "org/jetbrains/idea/devkit/testAssistant/TestDataRelatedItem", "<init>"));
        }
        super((PsiElement)method, "Test Data");
        this.myTestDataFiles = new ArrayList<String>();
        this.myMethod = method;
        this.myEditor = editor;
        this.myTestDataFiles.addAll(testDataFiles);
    }

    public String getCustomName() {
        if (this.myTestDataFiles.size() != 1) {
            return "test data";
        }
        return PathUtil.getFileName((String)this.myTestDataFiles.get(0));
    }

    public void navigate() {
        TestDataNavigationHandler.navigate(JBPopupFactory.getInstance().guessBestPopupLocation(this.myEditor), this.myTestDataFiles, this.myMethod.getProject());
    }
}

