/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgPushCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.push.HgVcsPushOptionValue;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgPusher
extends Pusher<HgRepository, HgPushSource, HgTarget> {
    private static final Logger LOG = Logger.getInstance(HgPusher.class);
    private static final String ONE = "one";
    private static Pattern PUSH_COMMITS_PATTERN = Pattern.compile(".*(?:added|pushed) (\\d+|one) changeset.*");
    static int PUSH_SUCCEEDED_EXIT_VALUE = 0;
    static int NOTHING_TO_PUSH_EXIT_VALUE = 1;

    public void push(@NotNull Map<HgRepository, PushSpec<HgPushSource, HgTarget>> pushSpecs, @Nullable VcsPushOptionValue vcsPushOptionValue, boolean force) {
        if (pushSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSpecs", "org/zmlx/hg4idea/push/HgPusher", "push"));
        }
        for (Map.Entry<HgRepository, PushSpec<HgPushSource, HgTarget>> entry : pushSpecs.entrySet()) {
            HgRepository repository = entry.getKey();
            PushSpec<HgPushSource, HgTarget> hgSpec = entry.getValue();
            HgTarget destination = (HgTarget)hgSpec.getTarget();
            HgPushSource source = (HgPushSource)hgSpec.getSource();
            Project project = repository.getProject();
            HgPushCommand pushCommand = new HgPushCommand(project, repository.getRoot(), destination.myTarget);
            pushCommand.setIsNewBranch(true);
            pushCommand.setForce(force);
            String branchName = source.getBranch();
            if (branchName.equals(repository.getCurrentBookmark())) {
                if (vcsPushOptionValue == HgVcsPushOptionValue.Current) {
                    pushCommand.setBookmarkName(branchName);
                } else {
                    pushCommand.setRevision(branchName);
                }
            } else {
                pushCommand.setBranchName(branchName);
            }
            HgPusher.pushSynchronously(project, pushCommand);
        }
    }

    public static void pushSynchronously(@NotNull Project project, @NotNull HgPushCommand command) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/push/HgPusher", "pushSynchronously"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/zmlx/hg4idea/push/HgPusher", "pushSynchronously"));
        }
        VirtualFile repo = command.getRepo();
        HgCommandResult result = command.executeInCurrentThread();
        if (result == null) {
            return;
        }
        if (result.getExitValue() == PUSH_SUCCEEDED_EXIT_VALUE) {
            int commitsNum = HgPusher.getNumberOfPushedCommits(result);
            String successTitle = "Pushed successfully";
            String successDescription = String.format("Pushed %d %s [%s]", commitsNum, StringUtil.pluralize((String)"commit", (int)commitsNum), repo.getPresentableName());
            VcsNotifier.getInstance((Project)project).notifySuccess(successTitle, successDescription);
        } else if (result.getExitValue() == NOTHING_TO_PUSH_EXIT_VALUE) {
            VcsNotifier.getInstance((Project)project).notifySuccess("Nothing to push");
        } else {
            new HgCommandResultNotifier(project).notifyError(result, "Push failed", "Failed to push to [" + repo.getPresentableName() + "]");
        }
    }

    static int getNumberOfPushedCommits(@NotNull HgCommandResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/zmlx/hg4idea/push/HgPusher", "getNumberOfPushedCommits"));
        }
        int numberOfCommitsInAllSubrepos = 0;
        List<String> outputLines = result.getOutputLines();
        for (String outputLine : outputLines) {
            Matcher matcher = PUSH_COMMITS_PATTERN.matcher(outputLine = outputLine.trim());
            if (!matcher.matches()) continue;
            try {
                String numberOfCommits = matcher.group(1);
                numberOfCommitsInAllSubrepos += ONE.equals(numberOfCommits) ? 1 : Integer.parseInt(numberOfCommits);
            }
            catch (NumberFormatException e) {
                LOG.error("getNumberOfPushedCommits ", (Throwable)e);
                return -1;
            }
        }
        return numberOfCommitsInAllSubrepos;
    }
}

