/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrTypeDefinitionRangeHandler
implements DeclarationRangeHandler<GrTypeDefinition> {
    @NotNull
    public TextRange getDeclarationRange(@NotNull GrTypeDefinition aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/codeInsight/hint/GrTypeDefinitionRangeHandler", "getDeclarationRange"));
        }
        if (aClass instanceof GrAnonymousClassDefinition) {
            GrNewExpression call = (GrNewExpression)aClass.getParent();
            int startOffset = call.getTextRange().getStartOffset();
            int endOffset = call.getArgumentList().getTextRange().getEndOffset();
            TextRange textRange = new TextRange(startOffset, endOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/hint/GrTypeDefinitionRangeHandler", "getDeclarationRange"));
            }
            return textRange;
        }
        GrModifierList modifierList = aClass.getModifierList();
        int startOffset = modifierList == null ? aClass.getTextRange().getStartOffset() : modifierList.getTextRange().getStartOffset();
        GrImplementsClause implementsList = aClass.getImplementsClause();
        int endOffset = implementsList == null ? aClass.getTextRange().getEndOffset() : implementsList.getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/hint/GrTypeDefinitionRangeHandler", "getDeclarationRange"));
        }
        return textRange;
    }
}

