/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

public final class MethodCallData {
    private final PsiElement backingElement;
    private boolean isNegated;
    private GrExpression base;
    private GrExpression[] arguments;
    private IElementType comparison;

    @Nullable
    public static MethodCallData create(@NotNull PsiElement backingElement) {
        if (backingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingElement", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/MethodCallData", "create"));
        }
        return Builder.build(backingElement);
    }

    private MethodCallData(@NotNull PsiElement backingElement) {
        if (backingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingElement", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/MethodCallData", "<init>"));
        }
        this.backingElement = backingElement;
    }

    @NotNull
    public PsiElement getBackingElement() {
        PsiElement psiElement = this.backingElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/MethodCallData", "getBackingElement"));
        }
        return psiElement;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    @NotNull
    public String getBase() {
        String string = this.base.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/MethodCallData", "getBase"));
        }
        return string;
    }

    @Nullable
    public String getArgument(int i) {
        return i >= this.arguments.length ? null : this.arguments[i].getText();
    }

    @Nullable
    public IElementType getComparison() {
        return this.comparison;
    }

    static /* synthetic */ GrExpression[] access$402(MethodCallData x0, GrExpression[] x1) {
        x0.arguments = x1;
        return x1;
    }

    private static final class Builder {
        private Builder() {
        }

        @Nullable
        public static MethodCallData build(@NotNull PsiElement backingElement) {
            if (backingElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingElement", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/MethodCallData$Builder", "build"));
            }
            MethodCallData result = new MethodCallData(backingElement);
            PsiElement element = backingElement;
            element = Builder.handleNegation(result, element);
            element = Builder.handleComparison(result, element);
            return (element = Builder.handleMethodCall(result, element)) == null ? null : result;
        }

        private static PsiElement handleNegation(MethodCallData result, @Nullable PsiElement element) {
            if (element == null) {
                return null;
            }
            result.isNegated = BoolUtils.isNegation(element);
            if (result.isNegated) {
                element = ((GrUnaryExpression)element).getOperand();
            }
            return element;
        }

        private static PsiElement handleComparison(MethodCallData result, @Nullable PsiElement element) {
            if (element == null) {
                return null;
            }
            if (ComparisonUtils.isComparison(element)) {
                GrBinaryExpression relationalExpression = (GrBinaryExpression)element;
                element = relationalExpression.getLeftOperand();
                result.comparison = relationalExpression.getOperationTokenType();
            }
            return element;
        }

        @Nullable
        private static PsiElement handleMethodCall(MethodCallData result, PsiElement element) {
            if (!(element instanceof GrMethodCall)) {
                return null;
            }
            GrMethodCall methodCall = (GrMethodCall)element;
            GrReferenceExpression invokedExpression = (GrReferenceExpression)methodCall.getInvokedExpression();
            GrExpression qualifierExpression = invokedExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return null;
            }
            result.base = Builder.addParenthesesIfNeeded(qualifierExpression);
            MethodCallData.access$402(result, Builder.addParenthesesIfNeeded(methodCall.getExpressionArguments()));
            return element;
        }

        private static GrExpression addParenthesesIfNeeded(@NotNull GrExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/MethodCallData$Builder", "addParenthesesIfNeeded"));
            }
            return Builder.needsParentheses(expression) ? Builder.createParenthesizedExpr(expression) : expression;
        }

        private static boolean needsParentheses(@NotNull GrExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/MethodCallData$Builder", "needsParentheses"));
            }
            return ParenthesesUtils.getPrecedence(expression) >= ParenthesesUtils.TYPE_CAST_PRECEDENCE;
        }

        private static GrExpression[] addParenthesesIfNeeded(GrExpression[] expressions) {
            GrExpression[] results = new GrExpression[expressions.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = Builder.addParenthesesIfNeeded(expressions[i]);
            }
            return results;
        }

        public static GrExpression createParenthesizedExpr(@NotNull GrExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/MethodCallData$Builder", "createParenthesizedExpr"));
            }
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
            return factory.createParenthesizedExpr(expression);
        }
    }
}

