/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;

class EqualsTransformation
extends BinaryTransformation {
    public EqualsTransformation() {
        super(null);
    }

    @Override
    protected GrExpression getExpandedElement(GrMethodCallExpression callExpression) {
        PsiElement parent = callExpression.getParent();
        return BoolUtils.isNegation(parent) ? (GrExpression)parent : super.getExpandedElement(callExpression);
    }

    @Override
    @Nullable
    protected IElementType getOperator(MethodCallData methodInfo, OptionsData optionsData) {
        return methodInfo.isNegated() ? GroovyTokenTypes.mNOT_EQUAL : GroovyTokenTypes.mEQUAL;
    }
}

