/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.CyclomaticComplexityVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyComplexMethodInspectionBase
extends GroovyMethodMetricInspection {
    @NotNull
    public String getDisplayName() {
        if ("Overly complex method" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyComplexMethodInspectionBase", "getDisplayName"));
        }
        return "Overly complex method";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Method Metrics" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyComplexMethodInspectionBase", "getGroupDisplayName"));
        }
        return "Method Metrics";
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Method complexity limit:";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' is overly complex ( cyclomatic complexity =" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyComplexMethodInspectionBase", "buildVisitor"));
        }
        return visitor;
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            int limit = GroovyOverlyComplexMethodInspectionBase.this.getLimit();
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor);
            int complexity = visitor.getComplexity();
            if (complexity <= limit) {
                return;
            }
            this.registerMethodError(grMethod, complexity, limit);
        }
    }
}

