/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyNestedSynchronizedStatementInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyNestedSynchronizedStatementInspection", "getGroupDisplayName"));
        }
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Nested 'synchronized' statement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyNestedSynchronizedStatementInspection", "getDisplayName"));
        }
        return "Nested 'synchronized' statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Nested '#ref' statement #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyNestedSynchronizedStatementInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(GrSynchronizedStatement synchronizedStatement) {
            super.visitSynchronizedStatement(synchronizedStatement);
            GrStatement parent = (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)synchronizedStatement, (Class[])new Class[]{GrSynchronizedStatement.class, GrClosableBlock.class});
            if (parent instanceof GrSynchronizedStatement) {
                this.registerStatementError(synchronizedStatement, new Object[0]);
                return;
            }
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)synchronizedStatement, GrMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                this.registerStatementError(synchronizedStatement, new Object[0]);
            }
        }
    }
}

