/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class GroovyPositionManager
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcess myDebugProcess;
    private static final Set<FileType> ourFileTypes = Collections.singleton(GroovyFileType.GROOVY_FILE_TYPE);

    public GroovyPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        List<Location> list;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "locationsOfLine"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "locationsOfLine"));
        }
        GroovyPositionManager.checkGroovyFile(position);
        try {
            List<Location> locations;
            if (LOG.isDebugEnabled()) {
                LOG.debug("locationsOfLine: " + type + "; " + position);
            }
            int line = position.getLine() + 1;
            List<Location> list2 = locations = this.getDebugProcess().getVirtualMachineProxy().versionHigher("1.4") ? type.locationsOfLine("Java", null, line) : type.locationsOfLine(line);
            if (locations == null || locations.isEmpty()) {
                throw NoDataException.INSTANCE;
            }
            list = locations;
        }
        catch (AbsentInformationException e) {
            throw NoDataException.INSTANCE;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "locationsOfLine"));
        }
        return list;
    }

    @Nullable
    private static GroovyPsiElement findReferenceTypeSourceImage(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        if (element == null) {
            return null;
        }
        return (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrClosableBlock.class, GrTypeDefinition.class});
    }

    @Nullable
    private static PsiClass findEnclosingTypeDefinition(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        do {
            if (!((element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrTypeDefinition.class, GroovyFileBase.class})) instanceof GroovyFileBase)) continue;
            return ((GroovyFileBase)element).getScriptClass();
        } while (!(element instanceof GrTypeDefinition) || ((GrTypeDefinition)element).isAnonymous());
        return (GrTypeDefinition)element;
    }

    private static void checkGroovyFile(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "checkGroovyFile"));
        }
        if (!(position.getFile() instanceof GroovyFileBase)) {
            throw NoDataException.INSTANCE;
        }
    }

    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "createPrepareRequest"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("createPrepareRequest: " + position);
        }
        GroovyPositionManager.checkGroovyFile(position);
        String qName = GroovyPositionManager.getOuterClassName(position);
        if (qName != null) {
            return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, qName);
        }
        qName = GroovyPositionManager.findEnclosingName(position);
        if (qName == null) {
            throw NoDataException.INSTANCE;
        }
        ClassPrepareRequestor waitRequestor = new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                CompoundPositionManager positionManager = ((DebugProcessImpl)debuggerProcess).getPositionManager();
                if (!positionManager.locationsOfLine(referenceType, position).isEmpty()) {
                    requestor.processClassPrepare(debuggerProcess, referenceType);
                }
            }
        };
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(waitRequestor, qName + "$*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String findEnclosingName(@NotNull SourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "findEnclosingName"));
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            PsiClass typeDefinition = GroovyPositionManager.findEnclosingTypeDefinition(position);
            if (typeDefinition != null) {
                String string = GroovyPositionManager.getClassNameForJvm(typeDefinition);
                return string;
            }
            String string = GroovyPositionManager.getScriptQualifiedName(position);
            return string;
        }
        finally {
            accessToken.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getOuterClassName(SourcePosition position) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
            if (sourceImage instanceof GrTypeDefinition) {
                String string = GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
                return string;
            }
            if (sourceImage == null) {
                String string = GroovyPositionManager.getScriptQualifiedName(position);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            accessToken.finish();
        }
    }

    @Nullable
    private static String getClassNameForJvm(@NotNull PsiClass typeDefinition) {
        String qname;
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getClassNameForJvm"));
        }
        String suffix = typeDefinition instanceof GrTypeDefinition && ((GrTypeDefinition)typeDefinition).isTrait() ? "$Trait$Helper" : "";
        PsiClass psiClass = typeDefinition.getContainingClass();
        if (psiClass != null) {
            String parent = GroovyPositionManager.getClassNameForJvm(psiClass);
            return parent == null ? null : parent + "$" + typeDefinition.getName() + suffix;
        }
        PsiFile file = typeDefinition.getContainingFile();
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                String s;
                String string = s = helper.isAppropriateScriptFile((GroovyFile)file) ? helper.customizeClassName(typeDefinition) : null;
                if (s == null) continue;
                return s;
            }
        }
        return (qname = typeDefinition.getQualifiedName()) == null ? null : qname + suffix;
    }

    @Nullable
    private static String getScriptQualifiedName(@NotNull SourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getScriptQualifiedName"));
        }
        PsiFile file = position.getFile();
        if (file instanceof GroovyFile) {
            return GroovyPositionManager.getScriptFQName((GroovyFile)file);
        }
        return null;
    }

    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        PsiFile psiFile;
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSourcePosition: " + location);
        }
        if ((psiFile = this.getPsiFileByLocation(this.getDebugProcess().getProject(), location)) == null) {
            throw NoDataException.INSTANCE;
        }
        int lineNumber = this.calcLineIndex(location);
        if (lineNumber < 0) {
            throw NoDataException.INSTANCE;
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    private int calcLineIndex(Location location) {
        LOG.assertTrue(this.myDebugProcess != null);
        if (location == null) {
            return -1;
        }
        try {
            return location.lineNumber() - 1;
        }
        catch (InternalError e) {
            return -1;
        }
    }

    @Nullable
    private PsiFile getPsiFileByLocation(@NotNull Project project, @Nullable Location location) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getPsiFileByLocation"));
        }
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name().replace('/', '.');
        int dollar = originalQName.indexOf(36);
        String runtimeName = dollar >= 0 ? originalQName.substring(0, dollar) : originalQName;
        String qName = GroovyPositionManager.getOriginalQualifiedName(refType, runtimeName);
        GlobalSearchScope searchScope = GroovyPositionManager.addModuleContent(this.myDebugProcess.getSearchScope());
        GroovyShortNamesCache cache = GroovyShortNamesCache.getGroovyShortNamesCache(project);
        try {
            PsiClass clazz;
            List<PsiClass> classes = cache.getClassesByFQName(qName, searchScope, true);
            if (classes.isEmpty()) {
                classes = cache.getClassesByFQName(qName, searchScope, false);
            }
            if (classes.isEmpty()) {
                classes = cache.getClassesByFQName(qName, GlobalSearchScope.projectScope((Project)project), false);
            }
            PsiClass psiClass = clazz = classes.size() == 1 ? classes.get(0) : null;
            if (clazz != null) {
                return clazz.getContainingFile();
            }
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
        return GroovyPositionManager.getExtraScriptIfNotFound(project, refType, runtimeName, searchScope);
    }

    @Nullable
    private static PsiFile getExtraScriptIfNotFound(@NotNull Project project, @NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getExtraScriptIfNotFound"));
        }
        if (refType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refType", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getExtraScriptIfNotFound"));
        }
        if (runtimeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtimeName", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getExtraScriptIfNotFound"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getExtraScriptIfNotFound"));
        }
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            PsiFile file;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (file = helper.getExtraScriptIfNotFound(refType, runtimeName, project, searchScope)) == null) continue;
            return file;
        }
        return null;
    }

    private static GlobalSearchScope addModuleContent(GlobalSearchScope scope) {
        Module module;
        if (scope instanceof ModuleWithDependenciesScope && !(module = ((ModuleWithDependenciesScope)scope).getModule()).isDisposed()) {
            return scope.uniteWith(module.getModuleContentWithDependenciesScope());
        }
        return scope;
    }

    private static String getOriginalQualifiedName(@NotNull ReferenceType refType, @NotNull String runtimeName) {
        if (refType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refType", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getOriginalQualifiedName"));
        }
        if (runtimeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtimeName", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getOriginalQualifiedName"));
        }
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            String originalScriptName;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (originalScriptName = helper.getOriginalScriptName(refType, runtimeName)) == null) continue;
            return originalScriptName;
        }
        return runtimeName;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(final @NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getAllClasses"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllClasses: " + position);
        }
        GroovyPositionManager.checkGroovyFile(position);
        List result = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<ReferenceType>>(){

            public List<ReferenceType> compute() {
                GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
                if (sourceImage instanceof GrTypeDefinition && !((GrTypeDefinition)sourceImage).isAnonymous()) {
                    String qName = GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
                    if (qName != null) {
                        return GroovyPositionManager.this.myDebugProcess.getVirtualMachineProxy().classesByName(qName);
                    }
                } else if (sourceImage == null) {
                    String scriptName = GroovyPositionManager.getScriptQualifiedName(position);
                    if (scriptName != null) {
                        return GroovyPositionManager.this.myDebugProcess.getVirtualMachineProxy().classesByName(scriptName);
                    }
                } else {
                    String enclosingName = GroovyPositionManager.findEnclosingName(position);
                    if (enclosingName == null) {
                        return null;
                    }
                    List outers = GroovyPositionManager.this.myDebugProcess.getVirtualMachineProxy().classesByName(enclosingName);
                    ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(outers.size());
                    for (ReferenceType outer : outers) {
                        ReferenceType nested = GroovyPositionManager.this.findNested(outer, sourceImage, position);
                        if (nested == null) continue;
                        result.add(nested);
                    }
                    return result;
                }
                return null;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllClasses = " + result);
        }
        if (result == null) {
            throw NoDataException.INSTANCE;
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getAllClasses"));
        }
        return list;
    }

    @Nullable
    private static String getScriptFQName(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getScriptFQName"));
        }
        String packageName = groovyFile.getPackageName();
        String fileName = GroovyPositionManager.getRuntimeScriptName(groovyFile);
        return StringUtil.getQualifiedName((String)packageName, (String)fileName);
    }

    @Nullable
    private static String getRuntimeScriptName(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getRuntimeScriptName"));
        }
        if (groovyFile.isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                String runtimeScriptName;
                if (!helper.isAppropriateScriptFile(groovyFile) || (runtimeScriptName = helper.getRuntimeScriptName(groovyFile)) == null) continue;
                return runtimeScriptName;
            }
        }
        VirtualFile vFile = groovyFile.getVirtualFile();
        assert (vFile != null);
        return vFile.getNameWithoutExtension();
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, GroovyPsiElement toFind, SourcePosition classPosition) {
        VirtualMachineProxy vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            List nestedTypes = vmProxy.nestedTypes(fromClass);
            for (ReferenceType nested : nestedTypes) {
                ReferenceType found = this.findNested(nested, toFind, classPosition);
                if (found == null) continue;
                return found;
            }
            try {
                int lineNumber = classPosition.getLine() + 1;
                if (!fromClass.locationsOfLine(lineNumber).isEmpty()) {
                    return fromClass;
                }
                Iterator<Location> iterator = fromClass.allLineLocations().iterator();
                if (iterator.hasNext()) {
                    Location location = iterator.next();
                    SourcePosition candidateFirstPosition = SourcePosition.createFromLine((PsiFile)toFind.getContainingFile(), (int)(location.lineNumber() - 1));
                    if (toFind.equals(GroovyPositionManager.findReferenceTypeSourceImage(candidateFirstPosition))) {
                        return fromClass;
                    }
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public Set<? extends FileType> getAcceptedFileTypes() {
        Set<FileType> set = ourFileTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager", "getAcceptedFileTypes"));
        }
        return set;
    }
}

