/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.highlighter.GroovyDollarSlashyStringLexer;
import org.jetbrains.plugins.groovy.highlighter.GroovySlashyStringLexer;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public class GroovySyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"Line comment", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey ANNOTATION = TextAttributesKey.createTextAttributesKey((String)"Annotation", (TextAttributesKey)JavaHighlightingColors.ANNOTATION_NAME_ATTRIBUTES);
    public static final TextAttributesKey LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"Groovy var", (TextAttributesKey)JavaHighlightingColors.LOCAL_VARIABLE_ATTRIBUTES);
    public static final TextAttributesKey REASSIGNED_LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"Groovy reassigned var", (TextAttributesKey)JavaHighlightingColors.REASSIGNED_LOCAL_VARIABLE_ATTRIBUTES);
    public static final TextAttributesKey PARAMETER = TextAttributesKey.createTextAttributesKey((String)"Groovy parameter", (TextAttributesKey)JavaHighlightingColors.PARAMETER_ATTRIBUTES);
    public static final TextAttributesKey REASSIGNED_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"Groovy reassigned parameter", (TextAttributesKey)JavaHighlightingColors.REASSIGNED_PARAMETER_ATTRIBUTES);
    public static final TextAttributesKey METHOD_DECLARATION = TextAttributesKey.createTextAttributesKey((String)"Groovy method declaration", (TextAttributesKey)JavaHighlightingColors.METHOD_DECLARATION_ATTRIBUTES);
    public static final TextAttributesKey CONSTRUCTOR_DECLARATION = TextAttributesKey.createTextAttributesKey((String)"Groovy constructor declaration", (TextAttributesKey)JavaHighlightingColors.CONSTRUCTOR_DECLARATION_ATTRIBUTES);
    public static final TextAttributesKey INSTANCE_FIELD = TextAttributesKey.createTextAttributesKey((String)"Instance field", (TextAttributesKey)JavaHighlightingColors.INSTANCE_FIELD_ATTRIBUTES);
    public static final TextAttributesKey METHOD_CALL = TextAttributesKey.createTextAttributesKey((String)"Method call", (TextAttributesKey)JavaHighlightingColors.METHOD_CALL_ATTRIBUTES);
    public static final TextAttributesKey CONSTRUCTOR_CALL = TextAttributesKey.createTextAttributesKey((String)"Groovy constructor call", (TextAttributesKey)JavaHighlightingColors.CONSTRUCTOR_CALL_ATTRIBUTES);
    public static final TextAttributesKey STATIC_FIELD = TextAttributesKey.createTextAttributesKey((String)"Static field", (TextAttributesKey)JavaHighlightingColors.STATIC_FINAL_FIELD_ATTRIBUTES);
    public static final TextAttributesKey STATIC_METHOD_ACCESS = TextAttributesKey.createTextAttributesKey((String)"Static method access", (TextAttributesKey)JavaHighlightingColors.STATIC_METHOD_ATTRIBUTES);
    public static final TextAttributesKey BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"Block comment", (TextAttributesKey)JavaHighlightingColors.JAVA_BLOCK_COMMENT);
    public static final TextAttributesKey DOC_COMMENT_CONTENT = TextAttributesKey.createTextAttributesKey((String)"Groovydoc comment", (TextAttributesKey)JavaHighlightingColors.DOC_COMMENT);
    public static final TextAttributesKey DOC_COMMENT_TAG = TextAttributesKey.createTextAttributesKey((String)"Groovydoc tag", (TextAttributesKey)JavaHighlightingColors.DOC_COMMENT_TAG);
    public static final TextAttributesKey CLASS_REFERENCE = TextAttributesKey.createTextAttributesKey((String)"Class", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_REFERENCE);
    public static final TextAttributesKey TYPE_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"Type parameter", (TextAttributesKey)JavaHighlightingColors.TYPE_PARAMETER_NAME_ATTRIBUTES);
    public static final TextAttributesKey INSTANCE_PROPERTY_REFERENCE = TextAttributesKey.createTextAttributesKey((String)"Instance property reference ID", (TextAttributesKey)JavaHighlightingColors.INSTANCE_FIELD_ATTRIBUTES);
    public static final TextAttributesKey STATIC_PROPERTY_REFERENCE = TextAttributesKey.createTextAttributesKey((String)"Static property reference ID", (TextAttributesKey)JavaHighlightingColors.STATIC_FINAL_FIELD_ATTRIBUTES);
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"GROOVY_KEYWORD", (TextAttributesKey)JavaHighlightingColors.KEYWORD);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"Number", (TextAttributesKey)JavaHighlightingColors.NUMBER);
    public static final TextAttributesKey GSTRING = TextAttributesKey.createTextAttributesKey((String)"GString", (TextAttributesKey)JavaHighlightingColors.STRING);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"String", (TextAttributesKey)JavaHighlightingColors.STRING);
    public static final TextAttributesKey BRACES = TextAttributesKey.createTextAttributesKey((String)"Braces", (TextAttributesKey)JavaHighlightingColors.BRACES);
    public static final TextAttributesKey BRACKETS = TextAttributesKey.createTextAttributesKey((String)"Brackets", (TextAttributesKey)JavaHighlightingColors.BRACKETS);
    public static final TextAttributesKey PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"Parentheses", (TextAttributesKey)JavaHighlightingColors.PARENTHESES);
    public static final TextAttributesKey OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"Operation sign", (TextAttributesKey)JavaHighlightingColors.OPERATION_SIGN);
    public static final TextAttributesKey BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"Bad character", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    public static final TextAttributesKey UNRESOLVED_ACCESS = TextAttributesKey.createTextAttributesKey((String)"Unresolved reference access", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey LITERAL_CONVERSION = TextAttributesKey.createTextAttributesKey((String)"List/map to object conversion", (TextAttributesKey)JavaHighlightingColors.NUMBER);
    public static final TextAttributesKey MAP_KEY = TextAttributesKey.createTextAttributesKey((String)"Map key", (TextAttributesKey)JavaHighlightingColors.STRING);
    public static final TextAttributesKey VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"Valid string escape", (TextAttributesKey)JavaHighlightingColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"Invalid string escape", (TextAttributesKey)JavaHighlightingColors.INVALID_STRING_ESCAPE);
    public static final TextAttributesKey LABEL = TextAttributesKey.createTextAttributesKey((String)"Label", (TextAttributesKey)DefaultLanguageHighlighterColors.LABEL);
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    private static final Map<IElementType, TextAttributesKey> POWER_SAVE_MODE_ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    static final TokenSet tBLOCK_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mML_COMMENT, GroovyDocElementTypes.GROOVY_DOC_COMMENT});
    static final TokenSet tLINE_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSL_COMMENT, GroovyTokenTypes.mSH_COMMENT});
    static final TokenSet tBAD_CHARACTERS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mWRONG});
    static final TokenSet tGSTRINGS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mGSTRING_LITERAL});
    static final TokenSet tSTRINGS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSTRING_LITERAL});
    static final TokenSet tBRACES = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mRCURLY});
    static final TokenSet tPARENTHESES = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mRPAREN});
    static final TokenSet tBRACKETS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mRBRACK});
    static final TokenSet tOperators = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSets.BINARY_OP_SET, TokenSets.UNARY_OP_SET, TokenSets.ASSIGN_OP_SET});

    @NotNull
    public Lexer getHighlightingLexer() {
        GroovyHighlightingLexer groovyHighlightingLexer = new GroovyHighlightingLexer();
        if (groovyHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/highlighter/GroovySyntaxHighlighter", "getHighlightingLexer"));
        }
        return groovyHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = GroovySyntaxHighlighter.pack((TextAttributesKey)(PowerSaveMode.isEnabled() ? POWER_SAVE_MODE_ATTRIBUTES.get(tokenType) : ATTRIBUTES.get(tokenType)));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/highlighter/GroovySyntaxHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tLINE_COMMENTS, (TextAttributesKey)LINE_COMMENT);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBLOCK_COMMENTS, (TextAttributesKey)BLOCK_COMMENT);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBAD_CHARACTERS, (TextAttributesKey)BAD_CHARACTER);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)TokenSets.NUMBERS, (TextAttributesKey)NUMBER);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tGSTRINGS, (TextAttributesKey)GSTRING);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tSTRINGS, (TextAttributesKey)STRING);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)STRING, (IElementType[])new IElementType[]{GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END});
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBRACES, (TextAttributesKey)BRACES);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBRACKETS, (TextAttributesKey)BRACKETS);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tPARENTHESES, (TextAttributesKey)PARENTHESES);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tOperators, (TextAttributesKey)OPERATION_SIGN);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)VALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tLINE_COMMENTS, (TextAttributesKey)LINE_COMMENT);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tBLOCK_COMMENTS, (TextAttributesKey)BLOCK_COMMENT);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tBAD_CHARACTERS, (TextAttributesKey)BAD_CHARACTER);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)TokenSets.NUMBERS, (TextAttributesKey)NUMBER);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tGSTRINGS, (TextAttributesKey)GSTRING);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tSTRINGS, (TextAttributesKey)STRING);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TextAttributesKey)STRING, (IElementType[])new IElementType[]{GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tBRACES, (TextAttributesKey)BRACES);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tBRACKETS, (TextAttributesKey)BRACKETS);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tPARENTHESES, (TextAttributesKey)PARENTHESES);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TextAttributesKey)VALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TextAttributesKey)INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TextAttributesKey)INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)TokenSets.KEYWORDS, (TextAttributesKey)KEYWORD);
    }

    private static class GroovyHighlightingLexer
    extends LayeredLexer {
        private GroovyHighlightingLexer() {
            super((Lexer)new GroovyLexer());
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\uffff', GroovyTokenTypes.mSTRING_LITERAL, true, "$"), new IElementType[]{GroovyTokenTypes.mSTRING_LITERAL}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\uffff', GroovyTokenTypes.mGSTRING_LITERAL, true, "$"), new IElementType[]{GroovyTokenTypes.mGSTRING_LITERAL}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\uffff', GroovyTokenTypes.mGSTRING_CONTENT, true, "$"), new IElementType[]{GroovyTokenTypes.mGSTRING_CONTENT}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new GroovySlashyStringLexer(), new IElementType[]{GroovyTokenTypes.mREGEX_CONTENT}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new GroovyDollarSlashyStringLexer(), new IElementType[]{GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT}, IElementType.EMPTY_ARRAY);
        }
    }
}

