/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.documentation.TypePresentation;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyPresentationUtil {
    private static final int CONSTRAINTS_NUMBER = 2;

    public static void appendParameterPresentation(GrParameter parameter, PsiSubstitutor substitutor, TypePresentation typePresentation, StringBuilder builder) {
        for (GrAnnotation annotation : parameter.getModifierList().getAnnotations()) {
            builder.append(annotation.getText()).append(' ');
        }
        PsiType type = parameter.getTypeGroovy();
        type = substitutor.substitute(type);
        if (typePresentation == TypePresentation.LINK) {
            PsiImplUtil.appendTypeString(builder, type, parameter);
            builder.append(' ').append(parameter.getName());
            return;
        }
        if (type != null) {
            if (typePresentation == TypePresentation.PRESENTABLE) {
                builder.append(type.getPresentableText()).append(' ').append(parameter.getName());
            } else if (typePresentation == TypePresentation.CANONICAL) {
                builder.append(type.getCanonicalText()).append(' ').append(parameter.getName());
            }
        } else {
            builder.append(parameter.getName());
            Set structural = Collections.synchronizedSet(new LinkedHashSet());
            ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).forEach(ref -> {
                PsiElement parent = ref.getElement().getParent();
                if (parent instanceof GrReferenceExpression) {
                    if (structural.size() >= 2) {
                        structural.add("...");
                        return false;
                    }
                    StringBuilder builder1 = new StringBuilder();
                    builder1.append(((GrReferenceElement)parent).getReferenceName());
                    PsiType[] argTypes = PsiUtil.getArgumentTypes(parent, true);
                    if (argTypes != null) {
                        builder1.append("(");
                        if (argTypes.length > 0) {
                            builder1.append(argTypes.length);
                            if (argTypes.length == 1) {
                                builder1.append(" arg");
                            } else {
                                builder1.append(" args");
                            }
                        }
                        builder1.append(')');
                    }
                    structural.add(builder1.toString());
                }
                return true;
            });
            if (!structural.isEmpty()) {
                builder.append(".");
                String[] array = ArrayUtil.toStringArray(structural);
                if (array.length > 1) {
                    builder.append("[");
                }
                for (int i = 0; i < array.length; ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append(array[i]);
                }
                if (array.length > 1) {
                    builder.append("]");
                }
            }
        }
    }

    public static String getSignaturePresentation(MethodSignature signature) {
        PsiType[] types;
        StringBuilder builder = new StringBuilder();
        builder.append(signature.getName()).append('(');
        for (PsiType type : types = signature.getParameterTypes()) {
            builder.append(type.getPresentableText()).append(", ");
        }
        if (types.length > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(")");
        return builder.toString();
    }
}

