/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrFlowInterruptingStatement;

public class GrLabelReference
implements PsiReference {
    private GrFlowInterruptingStatement myStatement;

    public GrLabelReference(GrFlowInterruptingStatement statement) {
        this.myStatement = statement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrLabelReference", "bindToElement"));
        }
        if (element instanceof GrLabeledStatement) {
            this.myStatement = this.handleElementRename(((GrLabeledStatement)element).getName());
        }
        throw new IncorrectOperationException("Can't bind not to labeled statement");
    }

    public TextRange getRangeInElement() {
        PsiElement identifier = this.myStatement.getLabelIdentifier();
        if (identifier == null) {
            return new TextRange(-1, -2);
        }
        int offsetInParent = identifier.getStartOffsetInParent();
        return new TextRange(offsetInParent, offsetInParent + identifier.getTextLength());
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public String getCanonicalText() {
        String name = this.myStatement.getLabelName();
        if (name == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrLabelReference", "getCanonicalText"));
            }
            return "";
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrLabelReference", "getCanonicalText"));
        }
        return string;
    }

    public GrFlowInterruptingStatement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.myStatement instanceof GrBreakStatement) {
            this.myStatement = (GrFlowInterruptingStatement)this.myStatement.replaceWithStatement(GroovyPsiElementFactory.getInstance(this.myStatement.getProject()).createStatementFromText("break " + newElementName));
        } else if (this.myStatement instanceof GrContinueStatement) {
            this.myStatement = (GrFlowInterruptingStatement)this.myStatement.replaceWithStatement(GroovyPsiElementFactory.getInstance(this.myStatement.getProject()).createStatementFromText("continue " + newElementName));
        }
        return this.myStatement;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<GrFlowInterruptingStatement> result = new ArrayList<GrFlowInterruptingStatement>();
        for (GrFlowInterruptingStatement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof GrLabeledStatement)) continue;
            result.add(context);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrLabelReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    public GrFlowInterruptingStatement getElement() {
        return this.myStatement;
    }

    public PsiElement resolve() {
        return this.myStatement.resolveLabel();
    }
}

