/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.smartPointers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.impl.smartPointers.TypePointerBase;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;

public class GrClassReferenceTypePointer
extends TypePointerBase<GrClassReferenceType>
implements SmartTypePointer {
    private static final Logger LOG = Logger.getInstance(GrClassReferenceTypePointer.class);
    private final SmartPsiElementPointer<GrReferenceElement> mySmartPsiElementPointer;
    private final String myReferenceText;
    private final Project myProject;

    public GrClassReferenceTypePointer(GrClassReferenceType type, Project project) {
        super((PsiType)type);
        this.myProject = project;
        GrReferenceElement reference = type.getReference();
        this.mySmartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)reference);
        this.myReferenceText = reference.getText();
    }

    @Nullable
    protected GrClassReferenceType calcType() {
        GrReferenceElement reference = (GrReferenceElement)this.mySmartPsiElementPointer.getElement();
        if (reference != null) {
            return new GrClassReferenceType(reference);
        }
        try {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myProject);
            GrTypeElement typeElement = factory.createTypeElement(this.myReferenceText, null);
            return (GrClassReferenceType)typeElement.getType();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

