/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionTypeCalculators;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryFacade;

public abstract class GrBinaryExpressionImpl
extends GrExpressionImpl
implements GrBinaryExpression {
    private static final ResolveCache.PolyVariantResolver<GrBinaryExpressionImpl> RESOLVER = new ResolveCache.PolyVariantResolver<GrBinaryExpressionImpl>(){

        @NotNull
        private List<GroovyResolveResult[]> resolveSubExpressions(@NotNull GrBinaryExpression expression, boolean incompleteCode) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "resolveSubExpressions"));
            }
            SmartList subExpressions = new SmartList();
            expression.getLeftOperand().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)subExpressions, incompleteCode){
                final /* synthetic */ List val$subExpressions;
                final /* synthetic */ boolean val$incompleteCode;
                {
                    this.val$subExpressions = list;
                    this.val$incompleteCode = bl;
                }

                public void visitElement(PsiElement element) {
                    if (element instanceof GrBinaryExpression) {
                        super.visitElement(element);
                    }
                }

                protected void elementFinished(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1$1", "elementFinished"));
                    }
                    if (element instanceof GrBinaryExpressionImpl) {
                        this.val$subExpressions.add(((GrBinaryExpressionImpl)element).multiResolve(this.val$incompleteCode));
                    }
                }
            });
            SmartList smartList = subExpressions;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "resolveSubExpressions"));
            }
            return smartList;
        }

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull GrBinaryExpressionImpl binary, boolean incompleteCode) {
            if (binary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binary", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "resolve"));
            }
            List<GroovyResolveResult[]> subExpressions = this.resolveSubExpressions(binary, incompleteCode);
            IElementType opType = binary.getOperationTokenType();
            PsiType lType = binary.getLeftType();
            if (lType == null) {
                if (GroovyResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "resolve"));
                }
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            PsiType rType = binary.getRightType();
            subExpressions.clear();
            GroovyResolveResult[] groovyResolveResultArray = TypesUtil.getOverloadedOperatorCandidates(lType, opType, binary, new PsiType[]{rType}, incompleteCode);
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$1", "resolve"));
            }
            return groovyResolveResultArray;
        }
    };
    private static final Function<GrBinaryExpressionImpl, PsiType> TYPE_CALCULATOR = expression -> (PsiType)GrBinaryExpressionTypeCalculators.getTypeCalculator(expression.getFacade()).fun((Object)expression.getFacade());
    private final GrBinaryFacade myFacade;

    @Nullable
    protected PsiType getRightType() {
        GrExpression rightOperand = this.getRightOperand();
        return rightOperand == null ? null : rightOperand.getType();
    }

    @Nullable
    protected PsiType getLeftType() {
        return this.getLeftOperand().getType();
    }

    public GrBinaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "<init>"));
        }
        super(node);
        this.myFacade = new GrBinaryFacade(){

            @Override
            @NotNull
            public GrExpression getLeftOperand() {
                GrExpression grExpression = GrBinaryExpressionImpl.this.getLeftOperand();
                if (grExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$2", "getLeftOperand"));
                }
                return grExpression;
            }

            @Override
            @Nullable
            public GrExpression getRightOperand() {
                return GrBinaryExpressionImpl.this.getRightOperand();
            }

            @Override
            @NotNull
            public IElementType getOperationTokenType() {
                IElementType iElementType = GrBinaryExpressionImpl.this.getOperationTokenType();
                if (iElementType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$2", "getOperationTokenType"));
                }
                return iElementType;
            }

            @Override
            @NotNull
            public PsiElement getOperationToken() {
                PsiElement psiElement = GrBinaryExpressionImpl.this.getOperationToken();
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$2", "getOperationToken"));
                }
                return psiElement;
            }

            @Override
            @NotNull
            public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
                GroovyResolveResult[] groovyResolveResultArray = GrBinaryExpressionImpl.this.multiResolve(incompleteCode);
                if (groovyResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$2", "multiResolve"));
                }
                return groovyResolveResultArray;
            }

            @Override
            @NotNull
            public GrExpression getPsiElement() {
                GrBinaryExpressionImpl grBinaryExpressionImpl = GrBinaryExpressionImpl.this;
                if (grBinaryExpressionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl$2", "getPsiElement"));
                }
                return grBinaryExpressionImpl;
            }
        };
    }

    @Override
    @NotNull
    public GrExpression getLeftOperand() {
        GrExpression grExpression = (GrExpression)this.findNotNullChildByClass(GrExpression.class);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "getLeftOperand"));
        }
        return grExpression;
    }

    @Override
    @Nullable
    public GrExpression getRightOperand() {
        PsiElement last = this.getLastChild();
        return last instanceof GrExpression ? (GrExpression)last : null;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        PsiElement child = this.getOperationToken();
        ASTNode node = child.getNode();
        assert (node != null);
        IElementType iElementType = node.getElementType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "getOperationTokenType"));
        }
        return iElementType;
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        PsiElement psiElement = this.findNotNullChildByType(TokenSets.BINARY_OP_SET);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "getOperationToken"));
        }
        return psiElement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray = TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement token = this.getOperationToken();
        int offset = token.getStartOffsetInParent();
        return new TextRange(offset, offset + token.getTextLength());
    }

    public PsiElement resolve() {
        return PsiImplUtil.extractUniqueElement(this.multiResolve(false));
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("binary expression cannot be renamed");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "bindToElement"));
        }
        throw new IncorrectOperationException("binary expression cannot be bound to anything");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrBinaryExpressionImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiReference getReference() {
        return this;
    }

    private GrBinaryFacade getFacade() {
        return this.myFacade;
    }
}

