/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrSuperReferenceResolver {
    @Nullable(value="null if ref is not 'super' reference")
    public static GroovyResolveResult[] resolveSuperExpression(@NotNull GrReferenceExpression ref) {
        GroovyResolveResult result;
        PsiElement resolved;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrSuperReferenceResolver", "resolveSuperExpression"));
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier == null) {
            PsiElement parent = ref.getParent();
            if (parent instanceof GrConstructorInvocation) {
                return ((GrConstructorInvocation)parent).multiResolve(false);
            }
            PsiClass aClass = PsiUtil.getContextClass(ref);
            if (aClass != null) {
                return GrSuperReferenceResolver.getSuperClass(aClass);
            }
        } else if (qualifier instanceof GrReferenceExpression && (resolved = (result = ((GrReferenceExpression)qualifier).advancedResolve()).getElement()) instanceof PsiClass) {
            PsiClass superClass = (PsiClass)resolved;
            GrTypeDefinition scopeClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)ref, GrTypeDefinition.class, (boolean)true);
            if (scopeClass != null && GrTraitUtil.isTrait(superClass) && scopeClass.isInheritor(superClass, false)) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)scopeClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return new GroovyResolveResultImpl[]{new GroovyResolveResultImpl((PsiElement)superClass, null, null, superClassSubstitutor, true, true)};
            }
            if (PsiUtil.hasEnclosingInstanceInScope(superClass, ref, false)) {
                return GrSuperReferenceResolver.getSuperClass(superClass);
            }
        }
        return null;
    }

    @NotNull
    private static GroovyResolveResult[] getSuperClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrSuperReferenceResolver", "getSuperClass"));
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass != null) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResultImpl[]{new GroovyResolveResultImpl((PsiElement)superClass, null, null, superClassSubstitutor, true, true)};
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrSuperReferenceResolver", "getSuperClass"));
            }
            return groovyResolveResultArray;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrSuperReferenceResolver", "getSuperClass"));
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }
}

