/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyStringLiteralManipulator
extends AbstractElementManipulator<GrLiteralContainer> {
    private static final Logger LOG = Logger.getInstance(GroovyStringLiteralManipulator.class);

    public GrLiteralContainer handleContentChange(@NotNull GrLiteralContainer expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText;
        String startQuote;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/plugins/groovy/lang/resolve/GroovyStringLiteralManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/lang/resolve/GroovyStringLiteralManipulator", "handleContentChange"));
        }
        if (!(expr.getValue() instanceof String)) {
            // empty if block
        }
        if (StringUtil.startsWithChar((CharSequence)(startQuote = GrStringUtil.getStartQuote(oldText = expr instanceof GrLiteral ? expr.getText() : expr.getParent().getText())), (char)'\'')) {
            newContent = GrStringUtil.escapeSymbolsForString(newContent, !startQuote.equals("'''"), true);
        } else if (StringUtil.startsWithChar((CharSequence)startQuote, (char)'\"')) {
            newContent = GrStringUtil.escapeSymbolsForGString(newContent, !startQuote.equals("\"\"\""), false);
        } else if ("/".equals(startQuote)) {
            newContent = GrStringUtil.escapeSymbolsForSlashyStrings(newContent);
        } else if ("$/".equals(startQuote)) {
            newContent = GrStringUtil.escapeSymbolsForDollarSlashyStrings(newContent);
        }
        String newText = expr instanceof GrLiteral ? oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset()) : newContent;
        return expr.updateText(newText);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull GrLiteralContainer element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/GroovyStringLiteralManipulator", "getRangeInElement"));
        }
        if (element instanceof GrStringContent) {
            TextRange textRange = TextRange.from((int)0, (int)element.getTextLength());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyStringLiteralManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        String text = element.getText();
        if (!(element.getValue() instanceof String)) {
            TextRange textRange = super.getRangeInElement((PsiElement)element);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyStringLiteralManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        TextRange textRange = GroovyStringLiteralManipulator.getLiteralRange(text);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyStringLiteralManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    public static TextRange getLiteralRange(String text) {
        int start = 1;
        int fin = text.length();
        String begin = text.substring(0, 1);
        if (text.startsWith("$/")) {
            start = 2;
            if (text.endsWith("/$")) {
                return new TextRange(start, Math.max(1, fin - 2));
            }
            return new TextRange(start, fin);
        }
        if (text.startsWith("\"\"\"") || text.startsWith("'''")) {
            start = 3;
            begin = text.substring(0, 3);
        }
        if (text.length() >= begin.length() * 2 && text.endsWith(begin)) {
            fin -= begin.length();
        }
        return new TextRange(start, Math.max(1, fin));
    }
}

