/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import com.intellij.psi.impl.light.LightTypeParameterBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderHelperLightPsiClass;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy.DefaultBuilderStrategySupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class InitializerBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String INITIALIZER_STRATEGY_NAME = "InitializerStrategy";
    public static final String SET_FQN = "groovy.transform.builder.InitializerStrategy.SET";
    public static final String UNSET_FQN = "groovy.transform.builder.InitializerStrategy.UNSET";

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport", "applyTransformation"));
        }
        new InitializerBuilderStrategyHandler(context).doProcess();
    }

    private static class InitializerTypeParameter
    extends LightTypeParameterBuilder {
        public InitializerTypeParameter(PsiTypeParameterListOwner owner, int index) {
            super("T" + index, owner, index);
        }
    }

    private static class InitializerBuilderStrategyHandler {
        @NotNull
        private final TransformationContext myContext;
        @NotNull
        private final GrTypeDefinition myContainingClass;
        @NotNull
        private final PsiElementFactory myElementFactory;

        private InitializerBuilderStrategyHandler(@NotNull TransformationContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "<init>"));
            }
            this.myContext = context;
            this.myContainingClass = context.getCodeClass();
            this.myElementFactory = PsiElementFactory.SERVICE.getInstance((Project)this.myContainingClass.getProject());
        }

        public void doProcess() {
            this.processTypeDefinition();
            this.processConstructors();
        }

        private void processTypeDefinition() {
            PsiAnnotation builderAnno = PsiImplUtil.getAnnotation((PsiModifierListOwner)this.myContainingClass, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(builderAnno, InitializerBuilderStrategySupport.INITIALIZER_STRATEGY_NAME)) {
                return;
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(builderAnno, this.myContainingClass.getCodeFields());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, builderAnno));
            this.myContext.addMethod((PsiMethod)this.createBuilderConstructor(this.myContainingClass, (PsiClass)builderClass, builderAnno));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters) {
            int i;
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderClass"));
            }
            if (setters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setters", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderClass"));
            }
            BuilderHelperLightPsiClass builderClass = new BuilderHelperLightPsiClass(this.myContainingClass, DefaultBuilderStrategySupport.getBuilderClassName(annotation, this.myContainingClass));
            for (i = 0; i < setters.length; ++i) {
                builderClass.getTypeParameterList().addParameter((PsiTypeParameter)new InitializerTypeParameter((PsiTypeParameterListOwner)builderClass, i));
            }
            for (i = 0; i < setters.length; ++i) {
                builderClass.addMethod((PsiMethod)this.createFieldSetter(builderClass, setters[i], annotation, i));
            }
            LightPsiClassBuilder lightPsiClassBuilder = builderClass.addMethod((PsiMethod)this.createBuildMethod(annotation, (PsiClass)builderClass));
            if (lightPsiClassBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderClass"));
            }
            return lightPsiClassBuilder;
        }

        @NotNull
        private LightMethodBuilder createFieldSetter(@NotNull LightPsiClassBuilder builderClass, @NotNull GrVariable field, @NotNull PsiAnnotation annotation, int currentField) {
            if (builderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createFieldSetter"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createFieldSetter"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createFieldSetter"));
            }
            String name = field.getName();
            LightMethodBuilder fieldSetter = new LightMethodBuilder(builderClass.getManager(), DefaultBuilderStrategySupport.getFieldMethodName(annotation, name));
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.put(builderClass.getTypeParameters()[currentField], (PsiType)this.myElementFactory.createTypeByFQClassName(InitializerBuilderStrategySupport.SET_FQN, annotation.getResolveScope()));
            fieldSetter.addModifier("public");
            fieldSetter.addParameter(name, field.getType());
            fieldSetter.setContainingClass((PsiClass)builderClass);
            fieldSetter.setMethodReturnType((PsiType)this.myElementFactory.createType((PsiClass)builderClass, substitutor));
            fieldSetter.setNavigationElement((PsiElement)field);
            fieldSetter.setOriginInfo("via @Builder");
            LightMethodBuilder lightMethodBuilder = fieldSetter;
            if (lightMethodBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createFieldSetter"));
            }
            return lightMethodBuilder;
        }

        private LightMethodBuilder createBuildMethod(@NotNull PsiAnnotation annotation, @NotNull PsiClass builderClass) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuildMethod"));
            }
            if (builderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuildMethod"));
            }
            LightMethodBuilder buildMethod = new LightMethodBuilder(annotation.getManager(), builderClass.getLanguage(), InitializerBuilderStrategyHandler.getBuildMethodName(annotation));
            buildMethod.addModifier("static");
            buildMethod.setContainingClass(builderClass);
            buildMethod.setOriginInfo("via @Builder");
            buildMethod.setNavigationElement((PsiElement)annotation);
            buildMethod.setMethodReturnType(this.createAllSetUnsetType(builderClass, false));
            return buildMethod;
        }

        @NotNull
        private LightMethodBuilder createBuilderMethod(@NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            if (builderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderMethod"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderMethod"));
            }
            LightMethodBuilder builderMethod = new LightMethodBuilder(this.myContext.getManager(), InitializerBuilderStrategyHandler.getBuilderMethodName(annotation));
            builderMethod.addModifier("static");
            builderMethod.setOriginInfo("via @Builder");
            builderMethod.setNavigationElement((PsiElement)annotation);
            builderMethod.setMethodReturnType(this.createAllSetUnsetType(builderClass, false));
            LightMethodBuilder lightMethodBuilder = builderMethod;
            if (lightMethodBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderMethod"));
            }
            return lightMethodBuilder;
        }

        @NotNull
        private LightMethodBuilder createBuilderConstructor(@NotNull PsiClass constructedClass, @NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            if (constructedClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructedClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderConstructor"));
            }
            if (builderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderConstructor"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderConstructor"));
            }
            LightMethodBuilder constructor = new LightMethodBuilder(constructedClass, constructedClass.getLanguage()).addParameter("builder", this.createAllSetUnsetType(builderClass, true)).setConstructor(true);
            constructor.setNavigationElement((PsiElement)annotation);
            constructor.setOriginInfo("via @Builder");
            LightMethodBuilder lightMethodBuilder = constructor;
            if (lightMethodBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createBuilderConstructor"));
            }
            return lightMethodBuilder;
        }

        private void processConstructors() {
            for (GrMethod method : this.myContainingClass.getCodeMethods()) {
                PsiAnnotation annotation = PsiImplUtil.getAnnotation(method, "groovy.transform.builder.Builder");
                if (!BuilderAnnotationContributor.isApplicable(annotation, InitializerBuilderStrategySupport.INITIALIZER_STRATEGY_NAME)) {
                    return;
                }
                if (!method.isConstructor()) continue;
                this.processConstructor(method, annotation);
            }
        }

        private void processConstructor(@NotNull GrMethod method, @NotNull PsiAnnotation annotation) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "processConstructor"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "processConstructor"));
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myContext.addMethod((PsiMethod)this.createBuilderConstructor(this.myContainingClass, (PsiClass)builderClass, annotation));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private static String getBuilderMethodName(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "getBuilderMethodName"));
            }
            String builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderMethodName");
            String string = StringUtil.isEmpty((String)builderMethodName) ? "createInitializer" : builderMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "getBuilderMethodName"));
            }
            return string;
        }

        @NotNull
        private static String getBuildMethodName(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "getBuildMethodName"));
            }
            String builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"buildMethodName");
            String string = StringUtil.isEmpty((String)builderMethodName) ? "create" : builderMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "getBuildMethodName"));
            }
            return string;
        }

        @NotNull
        private PsiType createAllSetUnsetType(@NotNull PsiClass builderClass, boolean setUnset) {
            if (builderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createAllSetUnsetType"));
            }
            PsiClassType type = this.myElementFactory.createTypeByFQClassName(setUnset ? InitializerBuilderStrategySupport.SET_FQN : InitializerBuilderStrategySupport.UNSET_FQN, builderClass.getResolveScope());
            PsiType[] mappings = PsiType.createArray((int)builderClass.getTypeParameters().length);
            for (int i = 0; i < mappings.length; ++i) {
                mappings[i] = type;
            }
            PsiClassType psiClassType = this.myElementFactory.createType(builderClass, mappings);
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/InitializerBuilderStrategySupport$InitializerBuilderStrategyHandler", "createAllSetUnsetType"));
            }
            return psiClassType;
        }
    }
}

