/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessorImpl;

public class PropertyResolverProcessor
extends ResolverProcessorImpl {
    public PropertyResolverProcessor(String name, PsiElement place) {
        super(name, ClassHint.RESOLVE_KINDS_PROPERTY, place, PsiType.EMPTY_ARRAY);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/processors/PropertyResolverProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/processors/PropertyResolverProcessor", "execute"));
        }
        return super.execute(element, state) || element instanceof PsiField;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        List<GroovyResolveResult> candidates = this.getCandidatesInternal();
        int size = candidates.size();
        if (size == 0) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/PropertyResolverProcessor", "getCandidates"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult last = (GroovyResolveResult)candidates.get(size - 1);
        if (last.getElement() instanceof GrBindingVariable && size > 1) {
            last = (GroovyResolveResult)candidates.get(size - 2);
        }
        if (PropertyResolverProcessor.isCorrectLocalVarOrParam(last)) {
            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{last};
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/PropertyResolverProcessor", "getCandidates"));
            }
            return groovyResolveResultArray;
        }
        for (GroovyResolveResult candidate : candidates) {
            if (!candidate.isStaticsOK()) continue;
            GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{candidate};
            if (groovyResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/PropertyResolverProcessor", "getCandidates"));
            }
            return groovyResolveResultArray;
        }
        GroovyResolveResult[] groovyResolveResultArray = candidates.toArray(new GroovyResolveResult[candidates.size()]);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/PropertyResolverProcessor", "getCandidates"));
        }
        return groovyResolveResultArray;
    }

    private static boolean isCorrectLocalVarOrParam(GroovyResolveResult last) {
        return !(last.getElement() instanceof PsiField) && last.isAccessible() && last.isStaticsOK() && last.getCurrentFileResolveContext() == null;
    }
}

