/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.variable;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;

public class GrVariableNameSuggester {
    private final GrIntroduceContext myContext;
    private final NameValidator myValidator;

    public GrVariableNameSuggester(GrIntroduceContext context, NameValidator validator) {
        this.myContext = context;
        this.myValidator = validator;
    }

    @NotNull
    public LinkedHashSet<String> suggestNames() {
        GrExpression expression = this.myContext.getExpression() != null ? this.myContext.getExpression() : this.myContext.getStringPart().getLiteral();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(GroovyNameSuggestionUtil.suggestVariableNames(expression, this.myValidator)));
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/variable/GrVariableNameSuggester", "suggestNames"));
        }
        return linkedHashSet;
    }
}

