/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.regexp;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.JavaRegExpHost;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;

public class GroovyRegExpHost
extends JavaRegExpHost {
    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        if (group.isNamedGroup()) {
            String version = GroovyRegExpHost.getGroovyVersion((PsiElement)group);
            return version != null && version.compareTo("2.0") >= 0;
        }
        return false;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        if (ref.isNamedGroupRef()) {
            String version = GroovyRegExpHost.getGroovyVersion((PsiElement)ref);
            return version != null && version.compareTo("2.0") >= 0;
        }
        return false;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        String version = GroovyRegExpHost.getGroovyVersion((PsiElement)regExpChar);
        return version != null && version.compareTo("2.0") >= 0;
    }

    private static String getGroovyVersion(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        return GroovyConfigUtils.getInstance().getSDKVersion(module);
    }
}

